/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.acteurbase;

import com.mastfrog.giulius.Dependencies;
import com.mastfrog.util.collections.CollectionUtils;
import com.mastfrog.util.collections.Converter;
import com.mastfrog.util.strings.Strings;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Inject;

public final class InstantiatingIterators {
    private final Dependencies deps;
    private final AtomicInteger position;

    @Inject
    InstantiatingIterators(Dependencies deps) {
        this.deps = deps;
        this.position = null;
    }

    InstantiatingIterators(Dependencies deps, AtomicInteger position) {
        this.deps = deps;
        this.position = position;
    }

    public <T> Iterable<T> iterable(final List<Object> obj, final Class<? extends T> type) {
        return CollectionUtils.toIterable((Iterator)CollectionUtils.convertedIterator((Converter)new Converter<T, Object>(){

            public Object unconvert(T r) {
                return r;
            }

            public String toString() {
                return "Converter for " + Strings.join((char)',', (Iterable)obj);
            }

            public T convert(Object t) {
                if (t instanceof Class) {
                    return type.cast(InstantiatingIterators.this.deps.getInstance((Class)t));
                }
                return type.cast(t);
            }
        }, new PermissiveIterator<Object>(obj, this.position)));
    }

    static class PermissiveIterator<T>
    implements Iterator<T> {
        private volatile int ix = 0;
        private final List<T> objs;
        private final AtomicInteger position;

        public PermissiveIterator(List<T> objs, AtomicInteger position) {
            this.objs = objs;
            this.position = position;
        }

        public String toString() {
            return "PermissiveIterator " + this.ix + " over " + Strings.join((char)',', this.objs) + " at " + this.position;
        }

        @Override
        public boolean hasNext() {
            return this.ix < this.objs.size();
        }

        @Override
        public T next() {
            if (this.position != null) {
                this.position.incrementAndGet();
            }
            return this.objs.get(this.ix++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported.");
        }
    }
}

