/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.acteur.headers;

import com.mastfrog.acteur.headers.AbstractHeader;
import com.mastfrog.acteur.headers.Method;
import com.mastfrog.util.preconditions.Checks;
import com.mastfrog.util.strings.Strings;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.util.internal.AppendableCharSequence;
import java.util.logging.Level;
import java.util.logging.Logger;

final class AllowHeader
extends AbstractHeader<Method[]> {
    AllowHeader(boolean isAllowOrigin) {
        super(Method[].class, (CharSequence)(isAllowOrigin ? HttpHeaderNames.ACCESS_CONTROL_ALLOW_METHODS : HttpHeaderNames.ALLOW));
    }

    @Override
    public CharSequence toCharSequence(Method[] value) {
        Checks.notNull((String)"value", (Object)value);
        if (value.length == 1) {
            return value[0].toCharSequence();
        }
        AppendableCharSequence append = new AppendableCharSequence(15);
        for (int i = 0; i < value.length; ++i) {
            append.append(value[i].toCharSequence());
            if (i == value.length - 1) continue;
            append.append(',');
        }
        return append;
    }

    @Override
    public Method[] toValue(CharSequence value) {
        Checks.notNull((String)"value", (Object)value);
        CharSequence[] s = Strings.split((char)',', (CharSequence)value);
        Method[] result = new Method[s.length];
        for (int i = 0; i < s.length; ++i) {
            try {
                result[i] = Method.valueOf(s[i]);
                continue;
            }
            catch (Exception e) {
                Logger.getLogger(AllowHeader.class.getName()).log(Level.INFO, "Bad methods in allow header '" + value + "'", e);
                return null;
            }
        }
        return result;
    }
}

