/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.acteur.headers;

import com.mastfrog.acteur.headers.BoundedRange;
import com.mastfrog.acteur.headers.Range;
import com.mastfrog.util.collections.CollectionUtils;
import com.mastfrog.util.preconditions.Checks;
import com.mastfrog.util.strings.Strings;
import io.netty.util.AsciiString;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ByteRanges
implements Iterable<Range> {
    private final boolean valid;
    public static final Pattern RANGE_PATTERN = Pattern.compile("^(\\d+)-(\\d+)");
    public static final Pattern START_RANGE_PATTERN = Pattern.compile("^(\\d+)-");
    public static final Pattern END_RANGE_PATTERN = Pattern.compile("^-(\\d+)");
    private final Range[] ranges;

    private ByteRanges(List<Range> ranges) {
        Checks.notNull((String)"ranges", ranges);
        Checks.notEmpty((String)"ranges", ranges);
        this.valid = true;
        this.ranges = ranges.toArray(new Range[ranges.size()]);
    }

    public ByteRanges(long start, long end) {
        this.ranges = new Range[]{new RangeImpl(start, end)};
        this.valid = end > start && end >= 0L && start >= 0L;
    }

    public ByteRanges(long start) {
        this.ranges = new Range[]{new StartRange(start)};
        this.valid = start >= 0L;
    }

    public ByteRanges(CharSequence rangeHeader) {
        boolean valid = true;
        ArrayList<Range> items = new ArrayList<Range>(4);
        if (!Strings.startsWithIgnoreCase((CharSequence)rangeHeader, (CharSequence)"bytes=")) {
            valid = false;
        } else {
            CharSequence rangeInfo = Strings.trim((CharSequence)rangeHeader.subSequence(6, rangeHeader.length()));
            if (rangeInfo.length() == 0) {
                valid = false;
            } else {
                CharSequence[] ranges;
                for (CharSequence range : ranges = Strings.split((char)',', (CharSequence)rangeInfo)) {
                    long val;
                    Matcher m = RANGE_PATTERN.matcher(range = Strings.trim((CharSequence)range));
                    if (m.find()) {
                        try {
                            long start = Long.parseLong(m.group(1));
                            long end = Long.parseLong(m.group(2));
                            if (start < 0L || end < 0L) {
                                valid = false;
                                break;
                            }
                            if (end < start) {
                                valid = false;
                                break;
                            }
                            items.add(new RangeImpl(start, end));
                            continue;
                        }
                        catch (NumberFormatException nfe) {
                            valid = false;
                            break;
                        }
                    }
                    m = START_RANGE_PATTERN.matcher(range);
                    if (m.find()) {
                        try {
                            val = Long.parseLong(m.group(1));
                            if (val < 0L) {
                                valid = false;
                                break;
                            }
                            items.add(new StartRange(val));
                            continue;
                        }
                        catch (NumberFormatException e) {
                            valid = false;
                            break;
                        }
                    }
                    m = END_RANGE_PATTERN.matcher(range);
                    if (!m.find()) continue;
                    try {
                        val = Long.parseLong(m.group(1));
                        if (val < 0L) {
                            valid = false;
                            break;
                        }
                        items.add(new EndRange(val));
                    }
                    catch (NumberFormatException nfe) {
                        valid = false;
                        break;
                    }
                }
            }
        }
        this.ranges = items.toArray(new Range[items.size()]);
        this.valid = valid;
    }

    public int size() {
        return this.ranges.length;
    }

    public Range first() {
        return this.ranges.length > 0 ? this.ranges[0] : null;
    }

    public Range get(int which) {
        return this.ranges[which];
    }

    public static ByteRanges of(long start, long end) {
        if (end < start) {
            throw new IllegalArgumentException("Start > end: " + start + " > " + end);
        }
        return new ByteRanges(Collections.singletonList(new RangeImpl(start, end)));
    }

    public boolean isValid() {
        return this.valid;
    }

    @Override
    public Iterator<Range> iterator() {
        return CollectionUtils.toIterator((Object[])this.ranges);
    }

    public CharSequence toCharSequence() {
        return new AsciiString((CharSequence)this.toString());
    }

    public String toString() {
        StringBuilder result = new StringBuilder("bytes=");
        for (int i = 0; i < this.ranges.length; ++i) {
            result.append(this.ranges[i]);
            if (i >= this.ranges.length - 1) continue;
            result.append(',');
        }
        return result.toString();
    }

    public boolean equals(Object o) {
        return o instanceof ByteRanges && o.toString().equals(this.toString());
    }

    public int hashCode() {
        return this.valid ? 1 : -1 + 7 * Arrays.hashCode(this.ranges);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class StartRange
    implements Range {
        final long startpoint;

        public StartRange(long startpoint) {
            this.startpoint = startpoint;
        }

        @Override
        public long start(long max) {
            if (this.startpoint > max) {
                return -1L;
            }
            return this.startpoint;
        }

        @Override
        public long end(long max) {
            return max - 1L;
        }

        public String toString() {
            return this.startpoint + "-";
        }

        @Override
        public BoundedRange toBoundedRange(long max) {
            return new BoundedRange(this.start(max), this.end(max), max);
        }
    }

    private static final class EndRange
    implements Range {
        final long endOffset;

        EndRange(long endOffset) {
            this.endOffset = endOffset;
        }

        @Override
        public long start(long max) {
            long result = max - this.endOffset;
            if (result < 0L) {
                return -1L;
            }
            return result;
        }

        @Override
        public long end(long max) {
            if (this.endOffset >= max) {
                return -1L;
            }
            return max;
        }

        public String toString() {
            return "-" + this.endOffset;
        }

        @Override
        public BoundedRange toBoundedRange(long max) {
            return new BoundedRange(this.start(max), this.end(max), max);
        }
    }

    private static final class RangeImpl
    implements Range {
        final long start;
        final long end;

        RangeImpl(long start, long end) {
            this.start = start;
            this.end = end;
        }

        @Override
        public long start(long max) {
            if (this.start > max) {
                return -1L;
            }
            return this.start;
        }

        @Override
        public long end(long max) {
            if (this.end >= max) {
                return -1L;
            }
            return this.end;
        }

        public String toString() {
            return this.start + "-" + this.end;
        }

        @Override
        public BoundedRange toBoundedRange(long max) {
            return new BoundedRange(this.start(max), this.end(max), max);
        }
    }

    public static final class Builder {
        private final List<Range> ranges = new ArrayList<Range>(4);

        private Builder() {
        }

        public final ByteRanges build() {
            return new ByteRanges(this.ranges);
        }

        public Builder add(Range range) {
            this.ranges.add(range);
            return this;
        }

        public Builder add(long start, long end) {
            if (end < start) {
                throw new IllegalArgumentException("start=" + start + ", end=" + end);
            }
            this.ranges.add(new RangeImpl(start, end));
            return this;
        }

        public Builder addStartpoint(long start) {
            if (start < 0L) {
                throw new IllegalArgumentException("Negative start " + start);
            }
            this.ranges.add(new StartRange(start));
            return this;
        }

        public Builder addFromEnd(long subtract) {
            if (subtract < 0L) {
                throw new IllegalArgumentException("Negative subtract: " + subtract);
            }
            this.ranges.add(new EndRange(subtract));
            return this;
        }
    }
}

