/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.acteur.headers;

import com.mastfrog.acteur.headers.AbstractHeader;
import com.mastfrog.acteur.util.CacheControl;
import com.mastfrog.util.preconditions.Checks;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.util.AsciiString;

final class CacheControlHeader
extends AbstractHeader<CacheControl> {
    private static final AsciiString PRIVATE_NO_CACHE_NO_STORE = AsciiString.of((CharSequence)CacheControl.PRIVATE_NO_CACHE_NO_STORE.toString());
    private static final AsciiString PUBLIC = AsciiString.of((CharSequence)CacheControl.PUBLIC.toString());
    private static final AsciiString PUBLIC_MUST_REVALIDATE = AsciiString.of((CharSequence)CacheControl.PUBLIC_MUST_REVALIDATE.toString());
    private static final AsciiString PUBLIC_MUST_REVALIDATE_MAX_AGE_1_DAY = AsciiString.of((CharSequence)CacheControl.PUBLIC_MUST_REVALIDATE_MAX_AGE_1_DAY.toString());
    private static final AsciiString PUBLIC_MUST_REVALIDATE_MAX_AGE_TEN_YEARS = AsciiString.of((CharSequence)CacheControl.PUBLIC_MAX_AGE_TEN_YEARS.toString());
    private static final AsciiString PUBLIC_MAX_AGE_TEN_YEARS = AsciiString.of((CharSequence)CacheControl.PUBLIC_MUST_REVALIDATE_MAX_AGE_TEN_YEARS.toString());
    private static final AsciiString PUBLIC_IMMUTABLE = AsciiString.of((CharSequence)CacheControl.PUBLIC_IMMUTABLE.toString());

    CacheControlHeader() {
        super(CacheControl.class, (CharSequence)HttpHeaderNames.CACHE_CONTROL);
    }

    @Override
    public String toString(CacheControl value) {
        Checks.notNull((String)"value", (Object)value);
        return value.toString();
    }

    @Override
    public CharSequence toCharSequence(CacheControl value) {
        if (value == CacheControl.PRIVATE_NO_CACHE_NO_STORE) {
            return PRIVATE_NO_CACHE_NO_STORE;
        }
        if (value == CacheControl.PUBLIC) {
            return PUBLIC;
        }
        if (value == CacheControl.PUBLIC_MUST_REVALIDATE) {
            return PUBLIC_MUST_REVALIDATE;
        }
        if (value == CacheControl.PUBLIC_MUST_REVALIDATE_MAX_AGE_1_DAY) {
            return PUBLIC_MUST_REVALIDATE_MAX_AGE_1_DAY;
        }
        if (value == CacheControl.PUBLIC_MAX_AGE_TEN_YEARS) {
            return PUBLIC_MAX_AGE_TEN_YEARS;
        }
        if (value == CacheControl.PUBLIC_MUST_REVALIDATE_MAX_AGE_TEN_YEARS) {
            return PUBLIC_MUST_REVALIDATE_MAX_AGE_TEN_YEARS;
        }
        if (value == CacheControl.PUBLIC_IMMUTABLE) {
            return PUBLIC_IMMUTABLE;
        }
        return this.toString(value);
    }

    @Override
    public CacheControl toValue(CharSequence value) {
        Checks.notNull((String)"value", (Object)value);
        return CacheControl.fromString((CharSequence)value);
    }
}

