/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.acteur.headers;

import com.mastfrog.acteur.headers.AbstractHeader;
import com.mastfrog.util.preconditions.Checks;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.cookie.ClientCookieEncoder;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.handler.codec.http.cookie.ServerCookieDecoder;
import java.util.Set;

final class CookieHeaderNetty428
extends AbstractHeader<Cookie[]> {
    private static final Cookie[] EMPTY = new Cookie[0];
    private final boolean strict;

    CookieHeaderNetty428(boolean strict) {
        super(Cookie[].class, (CharSequence)HttpHeaderNames.COOKIE);
        this.strict = strict;
    }

    @Override
    public CharSequence toCharSequence(Cookie[] value) {
        Checks.notNull((String)"value", (Object)value);
        return this.strict ? ClientCookieEncoder.STRICT.encode(value) : ClientCookieEncoder.LAX.encode(value);
    }

    @Override
    public Cookie[] toValue(CharSequence value) {
        ServerCookieDecoder decoder = this.strict ? ServerCookieDecoder.STRICT : ServerCookieDecoder.LAX;
        Set result = decoder.decode(((CharSequence)Checks.notNull((String)"value", (Object)value)).toString());
        return result == null ? EMPTY : result.toArray(new Cookie[result.size()]);
    }
}

