/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.acteur.headers;

import com.mastfrog.acteur.headers.AbstractHeader;
import com.mastfrog.acteur.headers.Headers;
import com.mastfrog.util.preconditions.Checks;
import com.mastfrog.util.strings.Strings;
import com.mastfrog.util.time.TimeUtil;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.util.Date;

class DateTimeHeader
extends AbstractHeader<ZonedDateTime> {
    DateTimeHeader(CharSequence name) {
        super(ZonedDateTime.class, name);
    }

    @Override
    public String toString(ZonedDateTime value) {
        Checks.notNull((String)"value", (Object)value);
        value = value.withZoneSameInstant(ZoneId.systemDefault());
        return Headers.toISO2822Date(value);
    }

    private ZonedDateTime mungeYear(ZonedDateTime dt) {
        int yr = dt.get(ChronoField.YEAR);
        if (yr < 100 && yr >= 0) {
            yr = yr >= 50 ? (yr += 1900) : (yr += 2000);
            dt = dt.withYear(yr);
        }
        return dt;
    }

    @Override
    public ZonedDateTime toValue(CharSequence value) {
        ZonedDateTime result;
        Checks.notNull((String)"value", (Object)value);
        try {
            ZonedDateTime top = ZonedDateTime.parse(value, Headers.ISO2822DateFormat);
            result = this.mungeYear(top);
        }
        catch (DateTimeParseException e) {
            try {
                ZonedDateTime rfs = ZonedDateTime.parse(value, DateTimeFormatter.RFC_1123_DATE_TIME);
                result = this.mungeYear(rfs);
            }
            catch (DateTimeParseException e1) {
                e.addSuppressed(e1);
                try {
                    CharSequence munged = value;
                    int space = Strings.indexOf((char)' ', (CharSequence)munged);
                    if (space != -1) {
                        munged = value.subSequence(space + 1, value.length());
                    }
                    ZonedDateTime dt = ZonedDateTime.parse(munged, Headers.TWO_DIGIT_YEAR);
                    result = this.mungeYear(dt);
                }
                catch (DateTimeParseException ex2) {
                    e.addSuppressed(ex2);
                    try {
                        long val = Date.parse(value.toString());
                        result = TimeUtil.fromUnixTimestamp((long)val);
                    }
                    catch (IllegalArgumentException e3) {
                        e.addSuppressed(e3);
                        new IllegalArgumentException(value.toString(), e).printStackTrace(System.err);
                        return null;
                    }
                }
            }
        }
        return result.withZoneSameInstant(ZoneId.systemDefault());
    }
}

