/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.acteur.headers;

import com.mastfrog.acteur.headers.AbstractHeader;
import com.mastfrog.acteur.util.FrameOptions;
import io.netty.util.AsciiString;

class FrameOptionsHeader
extends AbstractHeader<FrameOptions> {
    private static final AsciiString X_FRAME_OPTIONS = AsciiString.of((CharSequence)"x-frame-options");
    private static final AsciiString DENY = AsciiString.of((CharSequence)"DENY");
    private static final AsciiString SAMEORIGIN = AsciiString.of((CharSequence)"SAMEORIGIN");

    FrameOptionsHeader() {
        super(FrameOptions.class, (CharSequence)X_FRAME_OPTIONS);
    }

    @Override
    public CharSequence toCharSequence(FrameOptions value) {
        return AsciiString.of((CharSequence)value.toString());
    }

    @Override
    public boolean is(CharSequence name) {
        return X_FRAME_OPTIONS.contentEqualsIgnoreCase(name);
    }

    @Override
    public FrameOptions toValue(CharSequence value) {
        if (value == DENY || DENY.contentEqualsIgnoreCase(value)) {
            return FrameOptions.DENY;
        }
        if (value == SAMEORIGIN || SAMEORIGIN.contentEqualsIgnoreCase(value)) {
            return FrameOptions.SAMEORIGIN;
        }
        return FrameOptions.parse((CharSequence)value);
    }
}

