/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.acteur.headers;

import com.mastfrog.acteur.headers.AbstractHeader;
import com.mastfrog.acteur.headers.HeaderValueType;
import com.mastfrog.acteur.headers.Headers;
import com.mastfrog.util.strings.Strings;

class HeaderNamesHeader
extends AbstractHeader<HeaderValueType<?>[]> {
    HeaderNamesHeader(CharSequence name) {
        super(HeaderValueType[].class, name);
    }

    @Override
    public String toString(HeaderValueType[] value) {
        StringBuilder sb = new StringBuilder();
        for (HeaderValueType t : value) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(t.name());
        }
        return sb.toString();
    }

    @Override
    public HeaderValueType<?>[] toValue(CharSequence value) {
        if (value == null || value.length() == 0) {
            return new HeaderValueType[0];
        }
        CharSequence[] items = Strings.split((char)',', (CharSequence)value);
        HeaderValueType[] result = new HeaderValueType[items.length];
        for (int i = 0; i < items.length; ++i) {
            result[i] = Headers.header(items[i]);
        }
        return result;
    }
}

