/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.acteur.headers;

import com.google.common.net.MediaType;
import com.mastfrog.acteur.headers.AccelBufferingHeader;
import com.mastfrog.acteur.headers.AllowHeader;
import com.mastfrog.acteur.headers.AuthHeader;
import com.mastfrog.acteur.headers.BasicCredentialsHeader;
import com.mastfrog.acteur.headers.BooleanHeader;
import com.mastfrog.acteur.headers.BoundedRange;
import com.mastfrog.acteur.headers.ByteRangeHeader;
import com.mastfrog.acteur.headers.ByteRanges;
import com.mastfrog.acteur.headers.CacheControlHeader;
import com.mastfrog.acteur.headers.CharSequenceHeader;
import com.mastfrog.acteur.headers.CharsetHeader;
import com.mastfrog.acteur.headers.ConnectionHeader;
import com.mastfrog.acteur.headers.ContentRangeHeader;
import com.mastfrog.acteur.headers.CookieHeader;
import com.mastfrog.acteur.headers.CookieHeaderNetty428;
import com.mastfrog.acteur.headers.DateTimeHeader;
import com.mastfrog.acteur.headers.DurationHeader;
import com.mastfrog.acteur.headers.ETagHeader;
import com.mastfrog.acteur.headers.FrameOptionsHeader;
import com.mastfrog.acteur.headers.HeaderNamesHeader;
import com.mastfrog.acteur.headers.HeaderValueType;
import com.mastfrog.acteur.headers.KeepAliveHeader;
import com.mastfrog.acteur.headers.LocaleHeader;
import com.mastfrog.acteur.headers.MediaTypeHeader;
import com.mastfrog.acteur.headers.Method;
import com.mastfrog.acteur.headers.NumberHeader;
import com.mastfrog.acteur.headers.SetCookieHeader;
import com.mastfrog.acteur.headers.SetCookieHeaderNetty428;
import com.mastfrog.acteur.headers.StrictTransportSecurityHeader;
import com.mastfrog.acteur.headers.StringArrayHeader;
import com.mastfrog.acteur.headers.StringHeader;
import com.mastfrog.acteur.headers.UriHeader;
import com.mastfrog.acteur.headers.VaryHeader;
import com.mastfrog.acteur.headers.WebSocketProtocolsHeader;
import com.mastfrog.acteur.util.BasicCredentials;
import com.mastfrog.acteur.util.CacheControl;
import com.mastfrog.acteur.util.Connection;
import com.mastfrog.acteur.util.FrameOptions;
import com.mastfrog.acteur.util.Realm;
import com.mastfrog.acteur.util.StrictTransportSecurity;
import com.mastfrog.util.preconditions.Checks;
import io.netty.handler.codec.http.Cookie;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.util.AsciiString;
import java.net.URI;
import java.nio.charset.Charset;
import java.time.Duration;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.SignStyle;
import java.time.format.TextStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalField;
import java.util.Locale;

public final class Headers {
    public static final HeaderValueType<CharSequence> EXPECT = Headers.header((CharSequence)HttpHeaderNames.EXPECT);
    public static final HeaderValueType<ZonedDateTime> DATE = new DateTimeHeader((CharSequence)HttpHeaderNames.DATE);
    public static final HeaderValueType<ZonedDateTime> LAST_MODIFIED = new DateTimeHeader((CharSequence)HttpHeaderNames.LAST_MODIFIED);
    public static final HeaderValueType<ZonedDateTime> EXPIRES = new DateTimeHeader((CharSequence)HttpHeaderNames.EXPIRES);
    public static final HeaderValueType<ZonedDateTime> IF_MODIFIED_SINCE = new DateTimeHeader((CharSequence)HttpHeaderNames.IF_MODIFIED_SINCE);
    public static final HeaderValueType<ZonedDateTime> IF_UNMODIFIED_SINCE = new DateTimeHeader((CharSequence)HttpHeaderNames.IF_UNMODIFIED_SINCE);
    public static final HeaderValueType<ZonedDateTime> RETRY_AFTER_DATE = new DateTimeHeader((CharSequence)HttpHeaderNames.RETRY_AFTER);
    public static final HeaderValueType<Duration> RETRY_AFTER_DURATION = new DurationHeader((CharSequence)HttpHeaderNames.RETRY_AFTER);
    public static final HeaderValueType<CharSequence> HOST = Headers.header((CharSequence)HttpHeaderNames.HOST);
    public static final HeaderValueType<MediaType> CONTENT_TYPE = new MediaTypeHeader();
    public static final HeaderValueType<CharSequence> SERVER = Headers.header((CharSequence)HttpHeaderNames.SERVER);
    public static final HeaderValueType<HeaderValueType[]> VARY = new VaryHeader();
    public static final HeaderValueType<ByteRanges> RANGE = new ByteRangeHeader((CharSequence)HttpHeaderNames.RANGE);
    public static final HeaderValueType<BoundedRange> CONTENT_RANGE = new ContentRangeHeader((CharSequence)HttpHeaderNames.CONTENT_RANGE);
    public static final HeaderValueType<CharSequence> ACCEPT = Headers.header((CharSequence)HttpHeaderNames.ACCEPT);
    public static final HeaderValueType<CharSequence> ACCEPT_ENCODING = Headers.header((CharSequence)HttpHeaderNames.ACCEPT_ENCODING);
    public static final HeaderValueType<CharSequence> ACCEPT_RANGES = Headers.header((CharSequence)HttpHeaderNames.ACCEPT_RANGES);
    public static final HeaderValueType<CharSequence> CONTENT_ENCODING = Headers.header((CharSequence)HttpHeaderNames.CONTENT_ENCODING);
    public static final HeaderValueType<CharSequence> USER_AGENT = Headers.header((CharSequence)HttpHeaderNames.USER_AGENT);
    public static final HeaderValueType<Connection> CONNECTION = new ConnectionHeader();
    public static final HeaderValueType<Number> CONTENT_LENGTH = new NumberHeader((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
    public static final HeaderValueType<URI> CONTENT_LOCATION = new UriHeader((CharSequence)HttpHeaderNames.CONTENT_LOCATION);
    public static final HeaderValueType<URI> LOCATION = new UriHeader((CharSequence)HttpHeaderNames.LOCATION);
    public static final HeaderValueType<Charset> ACCEPT_CHARSET = new CharsetHeader((CharSequence)HttpHeaderNames.ACCEPT_CHARSET);
    public static final HeaderValueType<Locale> CONTENT_LANGUAGE = new LocaleHeader((CharSequence)HttpHeaderNames.CONTENT_LANGUAGE);
    public static final HeaderValueType<CharSequence> ETAG = new ETagHeader((CharSequence)HttpHeaderNames.ETAG);
    public static final HeaderValueType<CharSequence> IF_NONE_MATCH = new ETagHeader((CharSequence)HttpHeaderNames.IF_NONE_MATCH);
    public static final HeaderValueType<Duration> AGE = new DurationHeader((CharSequence)HttpHeaderNames.AGE);
    public static final HeaderValueType<Duration> RETRY_AFTER = new DurationHeader((CharSequence)HttpHeaderNames.RETRY_AFTER);
    public static final HeaderValueType<BasicCredentials> AUTHORIZATION = new BasicCredentialsHeader();
    public static final HeaderValueType<CacheControl> CACHE_CONTROL = new CacheControlHeader();
    public static final HeaderValueType<Realm> WWW_AUTHENTICATE = new AuthHeader();
    public static final HeaderValueType<Method[]> ALLOW = new AllowHeader(false);
    public static final HeaderValueType<Method[]> ACCESS_CONTROL_ALLOW = new AllowHeader(true);
    public static final HeaderValueType<String[]> ACCESS_CONTROL_ALLOW_ORIGIN = new StringArrayHeader((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_ORIGIN);
    public static final HeaderValueType<Number> ACCESS_CONTROL_ALLOW_MAX_AGE = new NumberHeader((CharSequence)HttpHeaderNames.ACCESS_CONTROL_MAX_AGE);
    public static final HeaderValueType<HeaderValueType<?>[]> ACCESS_CONTROL_ALLOW_HEADERS = new HeaderNamesHeader((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_HEADERS);
    public static final HeaderValueType<HeaderValueType<?>[]> ACCESS_CONTROL_EXPOSE_HEADERS = new HeaderNamesHeader((CharSequence)HttpHeaderNames.ACCESS_CONTROL_EXPOSE_HEADERS);
    public static final HeaderValueType<Boolean> ACCESS_CONTROL_ALLOW_CREDENTIALS = new BooleanHeader((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_CREDENTIALS);
    public static final HeaderValueType<CharSequence> X_REQUESTED_WITH = Headers.header((CharSequence)new AsciiString((CharSequence)"x-requested-with"));
    public static final HeaderValueType<CharSequence> X_FORWARDED_PROTO = Headers.header((CharSequence)new AsciiString((CharSequence)"x-forwarded-proto"));
    @Deprecated
    public static final HeaderValueType<Cookie> SET_COOKIE = new SetCookieHeader();
    public static final HeaderValueType<io.netty.handler.codec.http.cookie.Cookie> SET_COOKIE_B = new SetCookieHeaderNetty428((CharSequence)HttpHeaderNames.SET_COOKIE, false);
    public static final HeaderValueType<io.netty.handler.codec.http.cookie.Cookie> SET_COOKIE_B_STRICT = new SetCookieHeaderNetty428((CharSequence)HttpHeaderNames.SET_COOKIE, false);
    @Deprecated
    public static final HeaderValueType<Cookie[]> COOKIE = new CookieHeader();
    public static final HeaderValueType<io.netty.handler.codec.http.cookie.Cookie[]> COOKIE_B = new CookieHeaderNetty428(false);
    public static final HeaderValueType<io.netty.handler.codec.http.cookie.Cookie[]> COOKIE_B_STRICT = new CookieHeaderNetty428(true);
    public static final HeaderValueType<CharSequence[]> WEBSOCKET_PROTOCOLS = new WebSocketProtocolsHeader();
    public static final HeaderValueType<String> WEBSOCKET_PROTOCOL = new StringHeader((CharSequence)HttpHeaderNames.WEBSOCKET_PROTOCOL);
    public static final HeaderValueType<CharSequence> UPGRADE = Headers.header((CharSequence)HttpHeaderNames.UPGRADE);
    public static final HeaderValueType<CharSequence> REFERRER = Headers.header((CharSequence)HttpHeaderNames.REFERER);
    public static final HeaderValueType<CharSequence> TRANSFER_ENCODING = Headers.header((CharSequence)HttpHeaderNames.TRANSFER_ENCODING);
    public static final HeaderValueType<CharSequence> ACCESS_CONTROL_ALLOW_METHODS = Headers.header((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_METHODS);
    public static final HeaderValueType<Duration> ACCESS_CONTROL_MAX_AGE = new DurationHeader((CharSequence)HttpHeaderNames.ACCESS_CONTROL_MAX_AGE);
    public static final HeaderValueType<Boolean> X_ACCEL_BUFFERING = new AccelBufferingHeader();
    public static final HeaderValueType<Duration> KEEP_ALIVE = new KeepAliveHeader();
    public static final HeaderValueType<CharSequence> CONTENT_DISPOSITION = Headers.header((CharSequence)HttpHeaderNames.CONTENT_DISPOSITION);
    public static final HeaderValueType<Boolean> UPGRADE_INSECURE_REQUESTS = new BooleanHeader((CharSequence)AsciiString.of((CharSequence)"upgrade-insecure-requests"));
    public static final HeaderValueType<FrameOptions> X_FRAME_OPTIONS = new FrameOptionsHeader();
    public static final HeaderValueType<StrictTransportSecurity> STRICT_TRANSPORT_SECURITY = new StrictTransportSecurityHeader();
    public static final DateTimeFormatter ISO2822DateFormat = new DateTimeFormatterBuilder().appendText((TemporalField)ChronoField.DAY_OF_WEEK, TextStyle.SHORT_STANDALONE).appendLiteral(", ").appendText((TemporalField)ChronoField.DAY_OF_MONTH, TextStyle.FULL).appendLiteral(" ").appendText((TemporalField)ChronoField.MONTH_OF_YEAR, TextStyle.SHORT).appendLiteral(" ").appendText((TemporalField)ChronoField.YEAR, TextStyle.FULL).appendLiteral(" ").appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(":").appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral(":").appendValue(ChronoField.SECOND_OF_MINUTE, 2).appendLiteral(" ").appendOffsetId().toFormatter();
    static final DateTimeFormatter TWO_DIGIT_YEAR = new DateTimeFormatterBuilder().appendText((TemporalField)ChronoField.DAY_OF_MONTH, TextStyle.FULL).appendLiteral(" ").appendText((TemporalField)ChronoField.MONTH_OF_YEAR, TextStyle.SHORT).appendLiteral(" ").appendValue(ChronoField.YEAR, 2, 4, SignStyle.NEVER).appendLiteral(" ").appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(":").appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral(":").appendValue(ChronoField.SECOND_OF_MINUTE, 2).appendLiteral(" ").appendZoneOrOffsetId().toFormatter();
    static final ZoneId UTC = ZoneId.of("GMT");

    private Headers() {
    }

    public static HeaderValueType<String> stringHeader(CharSequence key) {
        return new StringHeader(key);
    }

    public static HeaderValueType<CharSequence> header(CharSequence key) {
        return new CharSequenceHeader(key);
    }

    public static <T> T read(HeaderValueType<T> type, HttpMessage msg) {
        String val = msg.headers().get(type.name());
        return val == null ? null : (T)type.toValue(val);
    }

    public static <T> CharSequence writeIfNotNull(HeaderValueType<T> type, T value, HttpMessage msg) {
        if (value != null) {
            return Headers.write(type, value, msg);
        }
        return null;
    }

    public static <T> CharSequence write(HeaderValueType<T> type, T value, HttpMessage msg) {
        Checks.notNull((String)"type", type);
        Checks.notNull((String)"msg", (Object)msg);
        Checks.notNull((String)("value " + type), value);
        CharSequence val = type.toCharSequence(value);
        msg.headers().add(type.name(), (Object)val);
        return val;
    }

    public static <T> CharSequence write(HeaderValueType<T> type, T value, HttpHeaders headers) {
        Checks.notNull((String)"type", type);
        Checks.notNull((String)"headers", (Object)headers);
        Checks.notNull((String)("value " + type), value);
        CharSequence val = type.toCharSequence(value);
        headers.add(type.name(), (Object)val);
        return val;
    }

    public static String toISO2822Date(ZonedDateTime dt) {
        return dt.format(ISO2822DateFormat);
    }
}

