/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.acteur.headers;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.net.MediaType;
import com.mastfrog.acteur.headers.AbstractHeader;
import com.mastfrog.util.preconditions.Checks;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.util.AsciiString;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;

final class MediaTypeHeader
extends AbstractHeader<MediaType> {
    private static final LoadingCache<MediaType, AsciiString> typeCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<MediaType, AsciiString>(){

        public AsciiString load(MediaType k) throws Exception {
            return new AsciiString((CharSequence)k.toString());
        }
    });
    private static final LoadingCache<CharSequence, MediaType> stringCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<CharSequence, MediaType>(){

        public MediaType load(CharSequence k) throws Exception {
            return MediaType.parse((String)k.toString());
        }
    });

    MediaTypeHeader() {
        super(MediaType.class, (CharSequence)HttpHeaderNames.CONTENT_TYPE);
    }

    @Override
    public CharSequence toCharSequence(MediaType value) {
        Checks.notNull((String)"value", (Object)value);
        try {
            return (CharSequence)typeCache.get((Object)value);
        }
        catch (ExecutionException ex) {
            Logger.getLogger(MediaTypeHeader.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    @Override
    public MediaType toValue(CharSequence value) {
        Checks.notNull((String)"value", (Object)value);
        try {
            return (MediaType)stringCache.get((Object)AsciiString.of((CharSequence)value));
        }
        catch (ExecutionException ex) {
            Logger.getLogger(MediaTypeHeader.class.getName()).log(Level.WARNING, "Bad media type {0}", value);
            return null;
        }
    }
}

