/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.acteur.headers;

import com.mastfrog.util.preconditions.Checks;
import com.mastfrog.util.strings.Strings;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.util.AsciiString;

public enum Method implements com.mastfrog.acteur.util.HttpMethod
{
    GET,
    PUT,
    POST,
    OPTIONS,
    HEAD,
    DELETE,
    TRACE,
    CONNECT,
    PROPFIND,
    PROPPATCH,
    MKCOL,
    COPY,
    MOVE,
    LOCK,
    UNLOCK,
    UNKNOWN,
    PATCH;

    private final AsciiString stringValue = AsciiString.of((CharSequence)this.name());

    public static Method get(HttpRequest req) {
        HttpMethod m = req.method();
        if (m == HttpMethod.GET) {
            return GET;
        }
        if (m == HttpMethod.PUT) {
            return PUT;
        }
        if (m == HttpMethod.POST) {
            return POST;
        }
        if (m == HttpMethod.PUT) {
            return PUT;
        }
        if (m == HttpMethod.OPTIONS) {
            return OPTIONS;
        }
        if (m == HttpMethod.HEAD) {
            return HEAD;
        }
        if (m == HttpMethod.PATCH) {
            return PATCH;
        }
        if (m == HttpMethod.TRACE) {
            return TRACE;
        }
        if (m == HttpMethod.CONNECT) {
            return CONNECT;
        }
        return Method.valueOf(m.name().toUpperCase());
    }

    public HttpMethod toHttpMethod() {
        switch (this) {
            case GET: {
                return HttpMethod.GET;
            }
            case PUT: {
                return HttpMethod.PUT;
            }
            case POST: {
                return HttpMethod.POST;
            }
            case OPTIONS: {
                return HttpMethod.OPTIONS;
            }
            case HEAD: {
                return HttpMethod.HEAD;
            }
            case PATCH: {
                return HttpMethod.PATCH;
            }
            case TRACE: {
                return HttpMethod.TRACE;
            }
            case CONNECT: {
                return HttpMethod.CONNECT;
            }
        }
        return HttpMethod.valueOf((String)this.name());
    }

    public String toString() {
        return this.name();
    }

    public CharSequence toCharSequence() {
        return this.stringValue;
    }

    public Method find(Object o) {
        for (Method m : Method.values()) {
            if (!m.is(o)) continue;
            return m;
        }
        return null;
    }

    public static Method valueOf(CharSequence seq) {
        Checks.notNull((String)"seq", (Object)seq);
        for (Method m : Method.values()) {
            if (!Strings.charSequencesEqual((CharSequence)seq, (CharSequence)m.stringValue)) continue;
            return m;
        }
        throw new IllegalArgumentException(seq.toString());
    }
}

