/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.acteur.headers;

import com.mastfrog.acteur.headers.AbstractHeader;
import com.mastfrog.util.preconditions.Checks;
import com.mastfrog.util.strings.Strings;

final class StringArrayHeader
extends AbstractHeader<String[]> {
    StringArrayHeader(CharSequence name) {
        super(String[].class, name);
    }

    @Override
    public String toString(String ... value) {
        Checks.notNull((String)"value", (Object)value);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < value.length; ++i) {
            sb.append(value[i]);
            if (i == value.length - 1) continue;
            sb.append(',');
        }
        return sb.toString();
    }

    @Override
    public String[] toValue(CharSequence value) {
        Checks.notNull((String)"value", (Object)value);
        CharSequence[] result = Strings.split((char)',', (CharSequence)value);
        String[] rr = new String[result.length];
        for (int i = 0; i < result.length; ++i) {
            rr[i] = result[i] instanceof String ? (String)result[i] : result[i].toString();
        }
        return rr;
    }
}

