/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.acteur.headers;

import com.mastfrog.acteur.headers.AbstractHeader;
import com.mastfrog.acteur.headers.Headers;
import com.mastfrog.util.preconditions.Checks;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;

final class UriHeader
extends AbstractHeader<URI> {
    UriHeader(CharSequence name) {
        super(URI.class, name);
    }

    @Override
    public String toString(URI value) {
        Checks.notNull((String)"value", (Object)value);
        return value.toString();
    }

    @Override
    public URI toValue(CharSequence value) {
        Checks.notNull((String)"value", (Object)value);
        try {
            return new URI(value.toString());
        }
        catch (URISyntaxException ex) {
            Logger.getLogger(Headers.class.getName()).log(Level.SEVERE, "Bad URI in " + this.name() + " - " + value, ex);
            return null;
        }
    }
}

