/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.function;

import com.mastfrog.function.LoggableConsumer;
import java.util.Objects;
import java.util.function.Consumer;

final class AndedConsumer<T>
implements LoggableConsumer<T> {
    private final Consumer<? super T> a;
    private final Consumer<? super T> b;
    static LoggableConsumer NO_OP = new Noop();

    public AndedConsumer(Consumer<? super T> a, Consumer<? super T> b) {
        this.a = a;
        this.b = b;
    }

    public String toString() {
        return this.a + " & " + this.b;
    }

    @Override
    public void accept(T t) {
        this.a.accept(t);
        this.b.accept(t);
    }

    public int hashCode() {
        int hash = 5;
        hash = 59 * hash + Objects.hashCode(this.a);
        hash = 59 * hash + Objects.hashCode(this.b);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AndedConsumer other = (AndedConsumer)obj;
        if (!Objects.equals(this.a, other.a)) {
            return false;
        }
        return Objects.equals(this.b, other.b);
    }

    static class Noop
    implements LoggableConsumer {
        Noop() {
        }

        @Override
        public void accept(Object t) {
        }

        @Override
        public Consumer andThen(Consumer after) {
            return after;
        }
    }
}

