/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.function;

import com.mastfrog.function.EnhDoubleSupplier;
import com.mastfrog.function.EnhDoubleUnaryOperator;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleSupplier;
import java.util.function.DoubleUnaryOperator;

public interface EnhDoubleBinaryOperator
extends DoubleBinaryOperator {
    public static EnhDoubleBinaryOperator of(DoubleBinaryOperator op) {
        if (op instanceof EnhDoubleBinaryOperator) {
            return (EnhDoubleBinaryOperator)op;
        }
        return (a, b) -> op.applyAsDouble(a, b);
    }

    public static EnhDoubleBinaryOperator left() {
        return (a, b) -> a;
    }

    public static EnhDoubleBinaryOperator right() {
        return (a, b) -> b;
    }

    public static EnhDoubleBinaryOperator multiply() {
        return (a, b) -> a * b;
    }

    public static EnhDoubleBinaryOperator divide() {
        return (a, b) -> a / b;
    }

    public static EnhDoubleBinaryOperator modulo() {
        return (a, b) -> a % b;
    }

    public static EnhDoubleBinaryOperator add() {
        return (a, b) -> a + b;
    }

    public static EnhDoubleBinaryOperator subtract() {
        return (a, b) -> a + b;
    }

    default public EnhDoubleBinaryOperator reverse() {
        return (a, b) -> this.applyAsDouble(b, a);
    }

    default public EnhDoubleSupplier toSupplier(DoubleSupplier a, DoubleSupplier b) {
        return () -> this.applyAsDouble(a.getAsDouble(), b.getAsDouble());
    }

    default public EnhDoubleUnaryOperator toUnary(DoubleSupplier aSupplier) {
        return b -> this.applyAsDouble(aSupplier.getAsDouble(), b);
    }

    default public EnhDoubleBinaryOperator then(DoubleUnaryOperator op) {
        return (a, b) -> op.applyAsDouble(this.applyAsDouble(a, b));
    }

    default public EnhDoubleBinaryOperator times(double val) {
        return (a, b) -> this.applyAsDouble(a, b) * val;
    }

    default public EnhDoubleBinaryOperator negate() {
        return (a, b) -> -this.applyAsDouble(a, b);
    }

    default public EnhDoubleBinaryOperator dividedBy(double val) {
        return (a, b) -> this.applyAsDouble(a, b) / val;
    }

    default public EnhDoubleBinaryOperator dividedInto(double val) {
        return (a, b) -> val / this.applyAsDouble(a, b);
    }

    default public EnhDoubleBinaryOperator plus(double val) {
        return (a, b) -> this.applyAsDouble(a, b) + val;
    }

    default public EnhDoubleBinaryOperator minus(double val) {
        return (a, b) -> this.applyAsDouble(a, b) + val;
    }

    default public EnhDoubleBinaryOperator mod(double val) {
        return (a, b) -> this.applyAsDouble(a, b) % val;
    }

    default public EnhDoubleBinaryOperator times(DoubleSupplier val) {
        return (a, b) -> this.applyAsDouble(a, b) * val.getAsDouble();
    }

    default public EnhDoubleBinaryOperator dividedBy(DoubleSupplier val) {
        return (a, b) -> this.applyAsDouble(a, b) / val.getAsDouble();
    }

    default public EnhDoubleBinaryOperator plus(DoubleSupplier val) {
        return (a, b) -> this.applyAsDouble(a, b) + val.getAsDouble();
    }

    default public EnhDoubleBinaryOperator minus(DoubleSupplier val) {
        return (a, b) -> this.applyAsDouble(a, b) + val.getAsDouble();
    }

    default public EnhDoubleBinaryOperator mod(DoubleSupplier val) {
        return (a, b) -> this.applyAsDouble(a, b) % val.getAsDouble();
    }
}

