/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.function;

import com.mastfrog.function.DoubleBiConsumer;

@FunctionalInterface
public interface FloatBiConsumer {
    public void accept(float var1, float var2);

    default public DoubleBiConsumer toDoubleBiConsumer() {
        return (a, b) -> {
            if (a < (double)Float.MIN_VALUE || a > 3.4028234663852886E38 || b < (double)Float.MIN_VALUE || b > 3.4028234663852886E38) {
                throw new IllegalArgumentException("Value out of range for floats: " + a + " and " + b);
            }
            this.accept((float)a, (float)b);
        };
    }

    public static FloatBiConsumer fromDoubleBiConsumer(DoubleBiConsumer bc) {
        return bc::accept;
    }
}

