/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.function;

import java.util.function.DoubleConsumer;

@FunctionalInterface
public interface FloatConsumer {
    public void accept(float var1);

    default public FloatConsumer andThen(FloatConsumer other) {
        return val -> {
            this.accept(val);
            other.accept(val);
        };
    }

    default public DoubleConsumer toDoubleConsumer() {
        return dbl -> {
            if (dbl < (double)Float.MIN_VALUE || dbl > 3.4028234663852886E38) {
                throw new IllegalArgumentException("Value out of range for float: " + dbl);
            }
            this.accept((float)dbl);
        };
    }

    public static FloatConsumer fromDoubleConsumer(DoubleConsumer c) {
        return val -> c.accept(val);
    }
}

