/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.function;

import com.mastfrog.function.DoubleQuadFunction;
import com.mastfrog.function.FloatSupplier;
import java.util.function.Supplier;

@FunctionalInterface
public interface FloatQuadFunction<T> {
    public T apply(float var1, float var2, float var3, float var4);

    default public Supplier<T> toSupplier(FloatSupplier sa, FloatSupplier sb, FloatSupplier sc, FloatSupplier sd) {
        return () -> this.apply(sa.getAsFloat(), sb.getAsFloat(), sc.getAsFloat(), sd.getAsFloat());
    }

    default public DoubleQuadFunction<T> toDoubleQuadFunction() {
        return (a, b, c, d) -> {
            if (a > 3.4028234663852886E38 || a < (double)Float.MIN_VALUE) {
                throw new IllegalArgumentException("Value 0 out of range for float: " + a);
            }
            if (b > 3.4028234663852886E38 || b < (double)Float.MIN_VALUE) {
                throw new IllegalArgumentException("Value 1 out of range for float: " + b);
            }
            if (c > 3.4028234663852886E38 || c < (double)Float.MIN_VALUE) {
                throw new IllegalArgumentException("Value 2 out of range for float: " + c);
            }
            if (d > 3.4028234663852886E38 || d < (double)Float.MIN_VALUE) {
                throw new IllegalArgumentException("Value 3 out of range for float: " + d);
            }
            return this.apply((float)a, (float)b, (float)c, (float)d);
        };
    }

    public static <T> FloatQuadFunction<T> fromDoubleFunction(DoubleQuadFunction<T> df) {
        return (a, b, c, d) -> df.apply(a, b, c, d);
    }
}

