/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.function;

import com.mastfrog.function.DoubleTriFunction;
import com.mastfrog.function.FloatSupplier;
import java.util.function.Supplier;

@FunctionalInterface
public interface FloatTriFunction<T> {
    public T apply(float var1, float var2, float var3);

    default public Supplier<T> toSupplier(FloatSupplier sa, FloatSupplier sb, FloatSupplier sc) {
        return () -> this.apply(sa.getAsFloat(), sb.getAsFloat(), sc.getAsFloat());
    }

    default public DoubleTriFunction<T> toDoubleTriFunction() {
        return (a, b, c) -> {
            if (a > 3.4028234663852886E38 || a < (double)Float.MIN_VALUE) {
                throw new IllegalArgumentException("Value 0 out of range for float: " + a);
            }
            if (b > 3.4028234663852886E38 || b < (double)Float.MIN_VALUE) {
                throw new IllegalArgumentException("Value 1 out of range for float: " + b);
            }
            if (c > 3.4028234663852886E38 || c < (double)Float.MIN_VALUE) {
                throw new IllegalArgumentException("Value 1 out of range for float: " + c);
            }
            return this.apply((float)a, (float)b, (float)c);
        };
    }

    public static <T> FloatTriFunction<T> fromDoubleFunction(DoubleTriFunction<T> df) {
        return (a, b, c) -> df.apply(a, b, c);
    }
}

