/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.function;

import java.io.Serializable;
import java.util.Arrays;
import java.util.function.IntSupplier;
import java.util.function.IntToLongFunction;
import java.util.function.IntUnaryOperator;
import java.util.function.LongSupplier;

public final class FunctionUtils {
    public static IntUnaryOperator asUnaryOperator(int[] arr) {
        return new ArrayIntUnaryOperator(arr);
    }

    public static IntToLongFunction asFunction(long[] arr) {
        return new ArrayIntToLongFunction(arr);
    }

    public static LongSupplier toLongSupplier(IntSupplier ints) {
        return ints::getAsInt;
    }

    public static IntSupplier toIntSupplier(LongSupplier supp) {
        return () -> {
            long val = supp.getAsLong();
            if (val > Integer.MAX_VALUE || val < Integer.MIN_VALUE) {
                throw new IllegalStateException("Value out of range for int: " + val);
            }
            return (int)val;
        };
    }

    private FunctionUtils() {
        throw new AssertionError();
    }

    private static final class ArrayIntUnaryOperator
    implements IntUnaryOperator,
    Serializable {
        private final int[] arr;

        public ArrayIntUnaryOperator(int[] arr) {
            this.arr = arr;
        }

        @Override
        public int applyAsInt(int operand) {
            return this.arr[operand];
        }

        public String toString() {
            return Arrays.toString(this.arr);
        }

        public int hashCode() {
            int hash = 7;
            hash = 19 * hash + Arrays.hashCode(this.arr);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ArrayIntUnaryOperator other = (ArrayIntUnaryOperator)obj;
            return Arrays.equals(this.arr, other.arr);
        }
    }

    private static final class ArrayIntToLongFunction
    implements IntToLongFunction,
    Serializable {
        private final long[] arr;

        public ArrayIntToLongFunction(long[] arr) {
            this.arr = arr;
        }

        @Override
        public long applyAsLong(int value) {
            return this.arr[value];
        }

        public int hashCode() {
            int hash = 7;
            hash = 11 * hash + Arrays.hashCode(this.arr);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ArrayIntToLongFunction other = (ArrayIntToLongFunction)obj;
            return Arrays.equals(this.arr, other.arr);
        }

        public String toString() {
            return Arrays.toString(this.arr);
        }
    }
}

