/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.function;

import com.mastfrog.function.LongBiPredicate;
import java.util.function.BooleanSupplier;
import java.util.function.IntPredicate;
import java.util.function.IntSupplier;

@FunctionalInterface
public interface IntBiPredicate {
    public static final IntBiPredicate NEVER = (a, b) -> false;
    public static final IntBiPredicate ALWAYS = (a, b) -> true;

    public boolean test(int var1, int var2);

    default public BooleanSupplier toBooleanSupplier(IntSupplier a, IntSupplier b) {
        return () -> this.test(a.getAsInt(), b.getAsInt());
    }

    default public IntBiPredicate negate() {
        return (a, b) -> !this.test(a, b);
    }

    default public IntBiPredicate or(IntBiPredicate other) {
        return (a, b) -> this.test(a, b) || other.test(a, b);
    }

    default public IntBiPredicate and(IntBiPredicate other) {
        return (a, b) -> this.test(a, b) && other.test(a, b);
    }

    default public IntBiPredicate xor(IntBiPredicate other) {
        return (a, b) -> this.test(a, b) != other.test(a, b);
    }

    default public IntBiPredicate andNot(IntBiPredicate other) {
        return this.and(other.negate());
    }

    default public LongBiPredicate toLongBiPredicate() {
        return (a, b) -> {
            if (a < Integer.MIN_VALUE || a > Integer.MAX_VALUE || b < Integer.MIN_VALUE || b > Integer.MAX_VALUE) {
                return false;
            }
            return this.test((int)a, (int)b);
        };
    }

    public static IntBiPredicate fromPredicates(final IntPredicate aPredicate, final IntPredicate bPredicate) {
        return new IntBiPredicate(){

            @Override
            public boolean test(int a, int b) {
                return aPredicate.test(a) && bPredicate.test(b);
            }

            public String toString() {
                return "{" + aPredicate + ", " + bPredicate + "}";
            }
        };
    }
}

