/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.function;

import com.mastfrog.function.IntBiPredicate;
import java.util.function.BooleanSupplier;
import java.util.function.LongPredicate;
import java.util.function.LongSupplier;

@FunctionalInterface
public interface LongBiPredicate {
    public static final LongBiPredicate NEVER = (a, b) -> false;
    public static final LongBiPredicate ALWAYS = (a, b) -> true;

    public boolean test(long var1, long var3);

    default public BooleanSupplier toBooleanSupplier(LongSupplier a, LongSupplier b) {
        return () -> this.test(a.getAsLong(), b.getAsLong());
    }

    default public LongBiPredicate negate() {
        return (a, b) -> !this.test(a, b);
    }

    default public LongBiPredicate or(LongBiPredicate other) {
        return (a, b) -> this.test(a, b) || other.test(a, b);
    }

    default public LongBiPredicate and(LongBiPredicate other) {
        return (a, b) -> this.test(a, b) && other.test(a, b);
    }

    default public LongBiPredicate andNot(LongBiPredicate other) {
        return this.and(other.negate());
    }

    default public LongBiPredicate xor(LongBiPredicate other) {
        return (a, b) -> this.test(a, b) != other.test(a, b);
    }

    default public IntBiPredicate toIntBiPredicate() {
        return (a, b) -> this.test(a, b);
    }

    public static LongBiPredicate fromPredicates(final LongPredicate aPredicate, final LongPredicate bPredicate) {
        return new LongBiPredicate(){

            @Override
            public boolean test(long a, long b) {
                return aPredicate.test(a) && bPredicate.test(b);
            }

            public String toString() {
                return "{" + aPredicate + ", " + bPredicate + "}";
            }
        };
    }
}

