/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.function;

import com.mastfrog.function.EnhIntSupplier;
import java.util.Comparator;
import java.util.function.Function;
import java.util.function.IntPredicate;
import java.util.function.Supplier;
import java.util.function.ToIntBiFunction;

@FunctionalInterface
public interface ToIntHomoBiFunction<T>
extends Comparator<T>,
ToIntBiFunction<T, T> {
    @Override
    public int applyAsInt(T var1, T var2);

    public static <R extends Comparable<R>> EnhIntSupplier comparer(Supplier<R> a, Supplier<R> b) {
        return () -> ((Comparable)a.get()).compareTo(b.get());
    }

    public static <R extends Comparable<R>> EnhIntSupplier comparer(R a, R b) {
        return () -> a.compareTo(b);
    }

    public static <R extends Comparable<R>> ToIntHomoBiFunction<R> comparison() {
        return Comparable::compareTo;
    }

    default public <R> ToIntHomoBiFunction<R> transform(Function<R, T> func) {
        return (a, b) -> this.applyAsInt((T)func.apply(a), (T)func.apply(b));
    }

    default public <R> ToIntHomoBiFunction<T> ifZero(R ra, R rb, ToIntHomoBiFunction<R> next) {
        return this.or((int value) -> value != 0, ra, rb, next);
    }

    default public <R> ToIntHomoBiFunction<T> ifZero(Supplier<R> ra, Supplier<R> rb, ToIntHomoBiFunction<R> next) {
        return this.or((int value) -> value != 0, ra, rb, next);
    }

    default public <R> ToIntHomoBiFunction<T> or(IntPredicate test, R ra, R rb, ToIntHomoBiFunction<R> next) {
        return (a, b) -> {
            int result = this.applyAsInt((T)a, (T)b);
            if (!test.test(result)) {
                return next.applyAsInt((T)ra, (T)rb);
            }
            return result;
        };
    }

    default public <R> ToIntHomoBiFunction<T> or(IntPredicate test, Supplier<R> ra, Supplier<R> rb, ToIntHomoBiFunction<R> next) {
        return (a, b) -> {
            int result = this.applyAsInt((T)a, (T)b);
            if (!test.test(result)) {
                return next.applyAsInt((T)ra.get(), (T)rb.get());
            }
            return result;
        };
    }

    default public EnhIntSupplier toIntSupplier(Supplier<T> a, Supplier<T> b) {
        return () -> this.applyAsInt((T)a.get(), (T)b.get());
    }

    default public EnhIntSupplier toIntSupplier(T a, T b) {
        return () -> this.applyAsInt(a, b);
    }

    @Override
    default public int compare(T o1, T o2) {
        return this.applyAsInt(o1, o2);
    }
}

