/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.function.throwing;

import com.mastfrog.function.throwing.ThrowingRunnable;
import java.util.concurrent.Callable;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;

final class ComposableThrowingRunnable
implements ThrowingRunnable {
    private ThrowingRunnable inner = ThrowingRunnable.NO_OP;
    private final boolean oneShot;
    private final boolean lifo;

    ComposableThrowingRunnable(boolean oneShot, boolean lifo) {
        this.oneShot = oneShot;
        this.lifo = lifo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() throws Exception {
        ThrowingRunnable in;
        ComposableThrowingRunnable composableThrowingRunnable = this;
        synchronized (composableThrowingRunnable) {
            in = this.inner;
            if (this.oneShot) {
                this.inner = ThrowingRunnable.NO_OP;
            }
        }
        in.run();
    }

    @Override
    public synchronized ThrowingRunnable andThen(ThrowingRunnable run) {
        this.inner = this.inner.andThen(run);
        return this;
    }

    @Override
    public synchronized ThrowingRunnable andAlwaysRun(Runnable run) {
        this.inner = this.lifo ? this.inner.andAlwaysRunFirst(run) : this.inner.andAlwaysRun(run);
        return this;
    }

    @Override
    public synchronized ThrowingRunnable andAlways(ThrowingRunnable run) {
        this.inner = this.lifo ? this.inner.andAlwaysFirst(run) : this.inner.andAlways(run);
        return this;
    }

    @Override
    public ThrowingRunnable andAlwaysRunFirst(Runnable run) {
        this.inner = !this.lifo ? this.inner.andAlwaysRunFirst(run) : this.inner.andAlwaysRun(run);
        return this;
    }

    @Override
    public ThrowingRunnable andAlwaysFirst(ThrowingRunnable run) {
        this.inner = !this.lifo ? this.inner.andAlwaysFirst(run) : this.inner.andAlways(run);
        return this;
    }

    @Override
    public synchronized ThrowingRunnable andAlwaysIf(BooleanSupplier test, ThrowingRunnable run) {
        this.inner = this.inner.andAlwaysIf(test, run);
        return this;
    }

    @Override
    public synchronized ThrowingRunnable andAlwaysIfNotNull(Supplier<?> testForNull, ThrowingRunnable run) {
        this.inner = this.inner.andAlwaysIfNotNull(testForNull, run);
        return this;
    }

    @Override
    public synchronized ThrowingRunnable andThenIfNotNull(Supplier<?> test, ThrowingRunnable run) {
        this.inner = this.inner.andThenIfNotNull(test, run);
        return this;
    }

    @Override
    public synchronized ThrowingRunnable andThenIf(BooleanSupplier test, ThrowingRunnable run) {
        this.inner = this.inner.andThenIf(test, run);
        return this;
    }

    @Override
    public synchronized ThrowingRunnable andThen(Runnable run) {
        this.inner = this.inner.andThen(run);
        return this;
    }

    @Override
    public synchronized ThrowingRunnable andThen(Callable<Void> run) {
        this.inner = this.inner.andThen(run);
        return this;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.inner + ")";
    }
}

