/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.function.throwing;

import com.mastfrog.util.preconditions.Exceptions;
import java.util.function.Consumer;
import java.util.function.Function;

@FunctionalInterface
public interface ThrowingConsumer<T> {
    public void accept(T var1) throws Exception;

    default public Consumer<T> asConsumer() {
        return obj -> {
            try {
                this.accept(obj);
            }
            catch (Exception ex) {
                Exceptions.chuck((Throwable)ex);
            }
        };
    }

    default public <R> ThrowingConsumer<R> adapt(Function<R, T> conversion) {
        return r -> this.accept(conversion.apply(r));
    }

    default public ThrowingConsumer<T> andThen(ThrowingConsumer<T> other) {
        return t -> {
            this.accept(t);
            other.accept(t);
        };
    }

    default public ThrowingConsumer<T> andThen(Consumer<T> other) {
        return t -> {
            this.accept(t);
            other.accept(t);
        };
    }
}

