/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.function.throwing;

import com.mastfrog.function.throwing.ThrowingSupplier;
import java.util.function.IntPredicate;
import java.util.function.IntSupplier;

@FunctionalInterface
public interface ThrowingIntSupplier {
    public int getAsInt() throws Exception;

    default public ThrowingIntSupplier or(IntPredicate test, IntSupplier next) {
        return () -> {
            int result = this.getAsInt();
            return test.test(result) ? result : next.getAsInt();
        };
    }

    default public ThrowingIntSupplier ifZero(IntSupplier next) {
        return () -> {
            int result = this.getAsInt();
            return result == 0 ? next.getAsInt() : result;
        };
    }

    default public ThrowingIntSupplier plus(IntSupplier next) {
        return () -> this.getAsInt() + next.getAsInt();
    }

    default public ThrowingIntSupplier times(IntSupplier next) {
        return () -> {
            int result = this.getAsInt();
            return result == 0 ? 0 : result * next.getAsInt();
        };
    }

    default public ThrowingIntSupplier minus(IntSupplier next) {
        return () -> this.getAsInt() - next.getAsInt();
    }

    default public ThrowingIntSupplier mod(IntSupplier next) {
        return () -> this.getAsInt() % next.getAsInt();
    }

    default public ThrowingIntSupplier bitwiseOr(IntSupplier next) {
        return () -> this.getAsInt() | next.getAsInt();
    }

    default public ThrowingIntSupplier bitwiseXor(IntSupplier next) {
        return () -> this.getAsInt() ^ next.getAsInt();
    }

    default public ThrowingIntSupplier bitwiseAnd(IntSupplier next) {
        return () -> this.getAsInt() & next.getAsInt();
    }

    default public ThrowingIntSupplier dividedBy(IntSupplier next) {
        return () -> {
            int result = this.getAsInt();
            int div = next.getAsInt();
            return result == 0 || div == 0 ? 0 : result / div;
        };
    }

    default public ThrowingIntSupplier or(IntPredicate test, ThrowingIntSupplier next) {
        return () -> {
            int result = this.getAsInt();
            return test.test(result) ? result : next.getAsInt();
        };
    }

    default public ThrowingIntSupplier ifZero(ThrowingIntSupplier next) {
        return () -> {
            int result = this.getAsInt();
            return result == 0 ? next.getAsInt() : result;
        };
    }

    default public ThrowingIntSupplier plus(ThrowingIntSupplier next) {
        return () -> this.getAsInt() + next.getAsInt();
    }

    default public ThrowingIntSupplier times(ThrowingIntSupplier next) {
        return () -> {
            int result = this.getAsInt();
            return result == 0 ? 0 : result * next.getAsInt();
        };
    }

    default public ThrowingIntSupplier minus(ThrowingIntSupplier next) {
        return () -> this.getAsInt() - next.getAsInt();
    }

    default public ThrowingIntSupplier mod(ThrowingIntSupplier next) {
        return () -> this.getAsInt() % next.getAsInt();
    }

    default public ThrowingIntSupplier bitwiseOr(ThrowingIntSupplier next) {
        return () -> this.getAsInt() | next.getAsInt();
    }

    default public ThrowingIntSupplier bitwiseXor(ThrowingIntSupplier next) {
        return () -> this.getAsInt() ^ next.getAsInt();
    }

    default public ThrowingIntSupplier bitwiseAnd(ThrowingIntSupplier next) {
        return () -> this.getAsInt() & next.getAsInt();
    }

    default public ThrowingIntSupplier dividedBy(ThrowingIntSupplier next) {
        return () -> {
            int result = this.getAsInt();
            int div = next.getAsInt();
            return result == 0 || div == 0 ? 0 : result / div;
        };
    }

    default public ThrowingSupplier<Integer> toBoxedSupplier() {
        return () -> this.getAsInt();
    }
}

