/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.function.throwing;

import com.mastfrog.util.preconditions.Exceptions;
import java.util.function.Function;
import java.util.function.Supplier;

@FunctionalInterface
public interface ThrowingSupplier<T> {
    public T get() throws Exception;

    default public Supplier<T> asSupplier() {
        return () -> {
            try {
                return this.get();
            }
            catch (Exception e) {
                return Exceptions.chuck((Throwable)e);
            }
        };
    }

    default public <R> ThrowingSupplier<R> adapt(Function<T, R> func) {
        return () -> func.apply(this.get());
    }
}

