/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.function.throwing.io;

import com.mastfrog.function.throwing.ThrowingBooleanSupplier;
import com.mastfrog.function.throwing.ThrowingRunnable;
import java.io.IOException;
import java.util.function.BooleanSupplier;

@FunctionalInterface
public interface IOBooleanSupplier
extends ThrowingBooleanSupplier {
    @Override
    public boolean getAsBoolean() throws IOException;

    @Override
    default public IOBooleanSupplier invert() {
        return () -> !this.getAsBoolean();
    }

    default public IOBooleanSupplier and(IOBooleanSupplier other) {
        return () -> this.getAsBoolean() && other.getAsBoolean();
    }

    default public IOBooleanSupplier andNot(IOBooleanSupplier other) {
        return () -> this.getAsBoolean() && !other.getAsBoolean();
    }

    default public IOBooleanSupplier or(IOBooleanSupplier other) {
        return () -> this.getAsBoolean() || other.getAsBoolean();
    }

    @Override
    default public IOBooleanSupplier and(BooleanSupplier other) {
        return () -> this.getAsBoolean() && other.getAsBoolean();
    }

    @Override
    default public IOBooleanSupplier andNot(BooleanSupplier other) {
        return () -> this.getAsBoolean() && !other.getAsBoolean();
    }

    @Override
    default public IOBooleanSupplier or(BooleanSupplier other) {
        return () -> this.getAsBoolean() || other.getAsBoolean();
    }

    @Override
    default public void ifTrue(ThrowingRunnable run) throws Exception {
        if (this.getAsBoolean()) {
            run.run();
        }
    }

    @Override
    default public void ifFalse(ThrowingRunnable run) throws Exception {
        if (!this.getAsBoolean()) {
            run.run();
        }
    }
}

