/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.util.cache;

import java.util.Optional;
import java.util.function.Function;

public interface Cache<T, R, E extends Exception>
extends AutoCloseable {
    public Cache<T, R, E> clear();

    @Override
    public void close();

    public R get(T var1) throws E;

    public Optional<R> getOptional(T var1) throws E;

    public Optional<R> cachedValue(T var1);

    default public <S> S ifAvailable(T key, Function<R, S> func) throws E {
        R result = this.get(key);
        if (result != null) {
            return func.apply(result);
        }
        return null;
    }

    default public <S> S ifAvailable(T key, S defaultValue, Function<R, S> func) throws E {
        R result = this.get(key);
        if (result != null) {
            return func.apply(result);
        }
        return defaultValue;
    }
}

