/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.util.cache;

import com.mastfrog.util.cache.Expirable;
import com.mastfrog.util.cache.TimedCache;
import com.mastfrog.util.preconditions.Exceptions;
import java.util.Collection;
import java.util.concurrent.DelayQueue;

class Expirer
implements Runnable {
    private final DelayQueue<Expirable> queue = new DelayQueue();
    private volatile boolean started;
    private final int prio;

    Expirer(int prio) {
        this.prio = prio;
    }

    Expirer() {
        this(1);
    }

    void removeAll(Collection<? extends Expirable> dead) {
        this.queue.removeAll(dead);
    }

    void offer(Expirable expirable) {
        this.queue.offer(expirable);
        this.checkStarted();
    }

    private void checkStarted() {
        if (!this.started) {
            this.started = true;
            Thread expireThread = new Thread(this);
            expireThread.setName("Global expirer for " + TimedCache.class.getSimpleName() + " entries");
            expireThread.setPriority(this.prio);
            expireThread.setDaemon(true);
            expireThread.start();
        }
    }

    void expireOne(Expirable toExpire) {
        toExpire.expire();
    }

    @Override
    public void run() {
        try {
            while (true) {
                Expirable toExpire = (Expirable)this.queue.take();
                this.expireOne(toExpire);
            }
        }
        catch (InterruptedException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return;
        }
    }
}

