/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.util.cache;

import com.mastfrog.util.cache.Answerer;
import com.mastfrog.util.cache.Cache;
import com.mastfrog.util.cache.TimedCache;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;

public interface TimedBidiCache<T, R, E extends Exception>
extends TimedCache<T, R, E> {
    public T getKey(R var1) throws E;

    public Optional<T> getKeyOptional(R var1) throws E;

    default public <S> S ifKeyAvailable(R value, Function<T, S> func) throws E {
        T result = this.getKey(value);
        if (result != null) {
            return func.apply(result);
        }
        return null;
    }

    default public <S> S ifKeyAvailable(R value, S defaultValue, Function<T, S> func) throws E {
        T result = this.getKey(value);
        if (result != null) {
            return func.apply(result);
        }
        return defaultValue;
    }

    public Optional<T> cachedKey(R var1);

    default public TimedBidiCache<R, T, E> reverse() {
        return new TimedBidiCache<R, T, E>(){

            @Override
            public R getKey(T value) throws Exception {
                return TimedBidiCache.this.get(value);
            }

            @Override
            public Optional<R> getKeyOptional(T value) throws Exception {
                return TimedBidiCache.this.getOptional(value);
            }

            @Override
            public TimedBidiCache<T, R, E> reverse() {
                return TimedBidiCache.this;
            }

            @Override
            public TimedCache<R, T, E> onExpire(BiConsumer<R, T> onExpire) {
                TimedBidiCache.this.onExpire((T t, R r) -> onExpire.accept(r, t));
                return this;
            }

            @Override
            public TimedBidiCache<R, T, E> toBidiCache(Answerer<T, R, E> reverseAnswerer) {
                return this;
            }

            @Override
            public Cache<R, T, E> clear() {
                TimedBidiCache.this.clear();
                return this;
            }

            @Override
            public void close() {
                TimedBidiCache.this.close();
            }

            @Override
            public T get(R key) throws Exception {
                return TimedBidiCache.this.getKey(key);
            }

            @Override
            public Optional<T> getOptional(R key) throws Exception {
                return TimedBidiCache.this.getKeyOptional(key);
            }

            @Override
            public Optional<T> cachedValue(R key) {
                return TimedBidiCache.this.cachedKey(key);
            }

            @Override
            public Optional<R> cachedKey(T value) {
                return TimedBidiCache.this.cachedValue(value);
            }
        };
    }
}

