/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.util.cache;

import com.mastfrog.util.cache.Answerer;
import com.mastfrog.util.cache.Cache;
import com.mastfrog.util.cache.MapSupplier;
import com.mastfrog.util.cache.TimedBidiCache;
import com.mastfrog.util.cache.TimedCacheImpl;
import java.util.function.BiConsumer;

public interface TimedCache<T, R, E extends Exception>
extends Cache<T, R, E> {
    public static <T, R, E extends Exception> TimedCache<T, R, E> createThrowing(long ttl, Answerer<T, R, E> answerer) {
        return new TimedCacheImpl<T, R, E>(ttl, answerer);
    }

    public static <T, R, E extends Exception> TimedCache<T, R, E> createThrowing(long ttl, Answerer<T, R, E> answerer, MapSupplier<T> backingStoreFactory) {
        return new TimedCacheImpl<T, R, E>(ttl, answerer, backingStoreFactory);
    }

    public static <T, R> TimedCache<T, R, RuntimeException> create(long ttl, Answerer<T, R, RuntimeException> answerer) {
        return new TimedCacheImpl<T, R, RuntimeException>(ttl, answerer);
    }

    public static <T, R> TimedCache<T, R, RuntimeException> create(long ttl, Answerer<T, R, RuntimeException> answerer, MapSupplier<T> backingStoreFactory) {
        return new TimedCacheImpl<T, R, RuntimeException>(ttl, answerer, backingStoreFactory);
    }

    default public boolean remove(T key) {
        throw new UnsupportedOperationException("Removal not supported");
    }

    public TimedCache<T, R, E> onExpire(BiConsumer<T, R> var1);

    public TimedBidiCache<T, R, E> toBidiCache(Answerer<R, T, E> var1);
}

