/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.util.cache;

import com.mastfrog.util.cache.Answerer;
import com.mastfrog.util.cache.Expirable;
import com.mastfrog.util.cache.Expirer;
import com.mastfrog.util.cache.MapSupplier;
import com.mastfrog.util.cache.TimedBidiCache;
import com.mastfrog.util.cache.TimedCache;
import com.mastfrog.util.preconditions.Checks;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;

class TimedCacheImpl<T, R, E extends Exception>
implements TimedCache<T, R, E> {
    final long timeToLive;
    private final Answerer<T, R, E> answerer;
    final Map<T, CacheEntry> cache;
    private BiConsumer<T, R> onExpire;
    private static Expirer EXPIRER;
    static Supplier<Expirer> expirerFactory;

    TimedCacheImpl(long ttl, Answerer<T, R, E> answerer) {
        this(ttl, answerer, ConcurrentHashMap::new);
    }

    TimedCacheImpl(long ttl, Answerer<T, R, E> answerer, MapSupplier<T> supp) {
        this.timeToLive = ttl;
        this.answerer = answerer;
        this.cache = supp.get();
    }

    private TimedCacheImpl(TimedCacheImpl<T, R, E> other) {
        this.timeToLive = other.timeToLive;
        this.answerer = other.answerer;
        this.cache = other.cache;
        this.onExpire = other.onExpire;
    }

    @Override
    public Optional<R> cachedValue(T key) {
        CacheEntry e = this.cache.get(key);
        return e == null ? Optional.empty() : Optional.ofNullable(e.value);
    }

    @Override
    public boolean remove(T key) {
        return this.cache.remove(key) != null;
    }

    public String toString() {
        return this.toString(new StringBuilder(this.getClass().getSimpleName()).append('{')).append('}').toString();
    }

    StringBuilder toString(StringBuilder sb) {
        sb.append("entries=[");
        Iterator<Map.Entry<T, CacheEntry>> it = this.cache.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<T, CacheEntry> e = it.next();
            sb.append(e.getKey()).append('=').append(e.getValue());
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        sb.append(']');
        return sb;
    }

    @Override
    public TimedCacheImpl<T, R, E> clear() {
        this.cache.clear();
        TimedCacheImpl.caches().removeAll(this.cache.values());
        return this;
    }

    boolean containsKey(T key) {
        return this.cache.containsKey(key);
    }

    @Override
    public Optional<R> getOptional(T key) throws E {
        return Optional.ofNullable(this.get(key));
    }

    @Override
    public void close() {
        for (CacheEntry e : this.cache.values()) {
            e.close();
        }
    }

    @Override
    public TimedCacheImpl<T, R, E> onExpire(BiConsumer<T, R> onExpire) {
        if (this.onExpire != null) {
            throw new IllegalStateException("OnExpire is already " + this.onExpire);
        }
        this.onExpire = onExpire;
        return this;
    }

    @Override
    public R get(T key) throws E {
        CacheEntry entry = this.cache.get(Checks.notNull((String)"key", key));
        if (entry == null) {
            R result = this.answerer.answer(key);
            if (result != null) {
                entry = this.createEntry(key, result);
            }
        } else {
            entry.touch();
        }
        return entry == null ? null : (R)entry.value;
    }

    CacheEntry createEntry(T key, R val) {
        CacheEntry result = new CacheEntry(key, val);
        this.cache.put(key, result);
        TimedCacheImpl.caches().offer(result);
        return result;
    }

    @Override
    public BidiCacheImpl<T, R, E> toBidiCache(Answerer<R, T, E> reverseAnswerer) {
        return new BidiCacheImpl<T, R, E>(this, reverseAnswerer);
    }

    void expireEntry(CacheEntry ce) {
        this.cache.remove(ce.key, ce);
        if (this.onExpire != null) {
            try {
                this.onExpire.accept(ce.key, ce.value);
            }
            catch (Exception e) {
                Logger.getLogger(TimedCacheImpl.class.getName()).log(Level.SEVERE, "Failure in onExpire", e);
            }
        }
    }

    static Expirer caches() {
        if (EXPIRER == null) {
            EXPIRER = expirerFactory.get();
        }
        return EXPIRER;
    }

    static {
        expirerFactory = () -> EXPIRER == null ? (EXPIRER = new Expirer()) : EXPIRER;
    }

    final class CacheEntry
    implements Expirable {
        volatile long touched = System.currentTimeMillis();
        final T key;
        final R value;

        public CacheEntry(T key, R value) {
            this.key = key;
            this.value = value;
        }

        public String toString() {
            return this.key + ":" + this.value;
        }

        void touch() {
            this.touched = System.currentTimeMillis();
        }

        void close() {
            this.touched = 0L;
        }

        @Override
        public void expire() {
            TimedCacheImpl.this.expireEntry(this);
        }

        @Override
        public boolean isExpired() {
            return this.remaining() <= 0L;
        }

        private long remaining() {
            return Math.max(0L, TimedCacheImpl.this.timeToLive - (System.currentTimeMillis() - this.touched));
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return unit.convert(this.remaining(), TimeUnit.MILLISECONDS);
        }

        @Override
        public int compareTo(Delayed o) {
            long a = this.getDelay(TimeUnit.MILLISECONDS);
            long b = o.getDelay(TimeUnit.MILLISECONDS);
            return Long.compare(a, b);
        }
    }

    static final class BidiCacheImpl<T, R, E extends Exception>
    extends TimedCacheImpl<T, R, E>
    implements TimedBidiCache<T, R, E> {
        private final Answerer<R, T, E> reverseAnswerer;
        private final Map<R, CacheEntry> reverseEntries = new ConcurrentHashMap<R, CacheEntry>();

        BidiCacheImpl(TimedCacheImpl<T, R, E> orig, Answerer<R, T, E> reverseAnswerer) {
            super(orig);
            this.reverseAnswerer = reverseAnswerer;
        }

        @Override
        public Optional<T> cachedKey(R value) {
            CacheEntry e = this.reverseEntries.get(value);
            return Optional.ofNullable(e.key);
        }

        @Override
        StringBuilder toString(StringBuilder sb) {
            sb.append(" reverse-entries=[");
            Iterator<Map.Entry<R, CacheEntry>> it = this.reverseEntries.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<R, CacheEntry> e = it.next();
                sb.append(e.getKey()).append('=').append(e.getValue());
                if (!it.hasNext()) continue;
                sb.append(", ");
            }
            sb.append(']');
            return sb;
        }

        @Override
        public BidiCacheImpl<T, R, E> clear() {
            this.reverseEntries.clear();
            super.clear();
            return this;
        }

        @Override
        public BidiCacheImpl<T, R, E> toBidiCache(Answerer<R, T, E> reverseAnswerer) {
            return this;
        }

        @Override
        public Optional<T> getKeyOptional(R value) throws E {
            return Optional.ofNullable(this.getKey(value));
        }

        boolean containsValue(R value) {
            return this.reverseEntries.containsKey(value);
        }

        @Override
        public String toString() {
            return this.reverseEntries.toString();
        }

        @Override
        public BidiCacheImpl<T, R, E> onExpire(BiConsumer<T, R> onExpire) {
            super.onExpire((BiConsumer)onExpire);
            return this;
        }

        @Override
        public T getKey(R value) throws E {
            CacheEntry entry = this.reverseEntries.get(Checks.notNull((String)"value", value));
            if (entry == null) {
                T result = this.reverseAnswerer.answer(value);
                if (result != null) {
                    entry = this.createEntry(result, value);
                }
            } else {
                entry.touch();
            }
            return entry == null ? null : (T)entry.key;
        }

        @Override
        void expireEntry(CacheEntry ce) {
            this.reverseEntries.remove(ce.value, ce);
            super.expireEntry(ce);
        }

        @Override
        CacheEntry createEntry(T key, R val) {
            CacheEntry result = super.createEntry(key, val);
            this.reverseEntries.put(val, result);
            return result;
        }
    }
}

