/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.util.collections;

import com.mastfrog.util.collections.ArrayBinarySet;
import com.mastfrog.util.collections.ArrayBinarySetMutable;
import com.mastfrog.util.collections.CollectionUtils;
import com.mastfrog.util.strings.Strings;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

class ArrayBinaryMap<T, R>
implements Map<T, R> {
    final Keys keys;
    private final Object[] vals;

    ArrayBinaryMap(Class<T> type, Comparator<T> comparator, int initialCapacity) {
        this.keys = new Keys(comparator, 10, type);
        this.vals = new Object[initialCapacity];
    }

    int end() {
        return this.keys.end;
    }

    @Override
    public int size() {
        return this.keys.size();
    }

    @Override
    public boolean isEmpty() {
        return this.keys.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.keys.contains(key);
    }

    @Override
    public boolean containsValue(Object value) {
        for (int i = 0; i <= this.end(); ++i) {
            if (!Objects.equals(value, this.vals[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public R get(Object key) {
        int ix = this.keys.indexOf(key);
        if (ix >= 0) {
            return (R)this.vals[ix];
        }
        return null;
    }

    @Override
    public R put(T key, R value) {
        if (!this.keys.add(key)) {
            int index = this.keys.indexOf(key);
            Object result = this.vals[index];
            this.vals[index] = value;
            return (R)result;
        }
        this.vals[this.end()] = value;
        System.out.println("PUT " + key + " " + value + " -> " + this);
        return null;
    }

    @Override
    public R remove(Object key) {
        int ix = this.keys.indexOf(key);
        if (ix >= 0) {
            Object result = this.vals[ix];
            this.keys.shiftLeft(ix, ix + 1, this.end() - ix);
            return (R)result;
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends T, ? extends R> m) {
        for (Map.Entry<T, R> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public void clear() {
        this.keys.clear();
        Arrays.fill(this.vals, null);
    }

    @Override
    public Set<T> keySet() {
        return this.keys;
    }

    public String toString() {
        StringBuilder result = new StringBuilder(this.getClass().getSimpleName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('{');
        for (int i = 0; i <= this.end(); ++i) {
            result.append(this.keys.objs[i]).append('=').append(this.vals[i]);
            if (i == this.end()) continue;
            result.append(", ");
        }
        return result.append('}').toString();
    }

    @Override
    public Collection<R> values() {
        return CollectionUtils.toList(this.vals);
    }

    @Override
    public Set<Map.Entry<T, R>> entrySet() {
        En[] ens = (En[])Array.newInstance(En.class, this.size());
        for (int i = 0; i < ens.length; ++i) {
            ens[i] = new En(i);
        }
        return new ArrayBinarySet<Object>(false, true, new CollectionUtils.ComparableComparator(), (Object[])ens);
    }

    private static <T> void sort(T[] a, Object[] with, int fromIndex, int toIndex, Comparator<T> comp) {
        ArrayBinaryMap.sort1(a, with, fromIndex, toIndex - fromIndex, comp);
    }

    private static <T> void sort1(T[] x, Object[] with, int off, int len, Comparator<T> comp) {
        int c;
        int a;
        if (len < 7) {
            for (int i = off; i < len + off; ++i) {
                for (int j = i; j > off && comp.compare(x[j - 1], x[j]) >= 1; --j) {
                    ArrayBinaryMap.swap(x, with, j, j - 1, comp);
                }
            }
            return;
        }
        int m = off + (len >> 1);
        if (len > 7) {
            int l = off;
            int n = off + len - 1;
            if (len > 40) {
                int s = len / 8;
                l = ArrayBinaryMap.med3(x, with, l, l + s, l + 2 * s, comp);
                m = ArrayBinaryMap.med3(x, with, m - s, m, m + s, comp);
                n = ArrayBinaryMap.med3(x, with, n - 2 * s, n - s, n, comp);
            }
            m = ArrayBinaryMap.med3(x, with, l, m, n, comp);
        }
        T v = x[m];
        int b = a = off;
        int d = c = off + len - 1;
        while (true) {
            if (b <= c && ArrayBinaryMap.isLessOrEqual(x[b], v, comp)) {
                if (x[b] == v) {
                    ArrayBinaryMap.swap(x, with, a++, b, comp);
                }
                ++b;
                continue;
            }
            while (c >= b && ArrayBinaryMap.isGreaterOrEqual(x[c], v, comp)) {
                if (x[c] == v) {
                    ArrayBinaryMap.swap(x, with, c, d--, comp);
                }
                --c;
            }
            if (b > c) break;
            ArrayBinaryMap.swap(x, with, b++, c--, comp);
        }
        int n = off + len;
        int s = Math.min(a - off, b - a);
        ArrayBinaryMap.vecswap(x, with, off, b - s, s, comp);
        s = Math.min(d - c, n - d - 1);
        ArrayBinaryMap.vecswap(x, with, b, n - s, s, comp);
        s = b - a;
        if (s > 1) {
            ArrayBinaryMap.sort1(x, with, off, s, comp);
        }
        if ((s = d - c) > 1) {
            ArrayBinaryMap.sort1(x, with, n - s, s, comp);
        }
    }

    private static <T> void swap(T[] x, Object[] with, int a, int b, Comparator<T> comp) {
        T t = x[a];
        x[a] = x[b];
        x[b] = t;
        Object w = with[a];
        with[a] = with[b];
        with[b] = w;
    }

    private static <T> void vecswap(T[] x, Object[] with, int a, int b, int n, Comparator<T> comp) {
        int i = 0;
        while (i < n) {
            ArrayBinaryMap.swap(x, with, a, b, comp);
            ++i;
            ++a;
            ++b;
        }
    }

    private static <T> int med3(T[] x, Object[] with, int a, int b, int c, Comparator<T> comp) {
        return ArrayBinaryMap.isLess(x[a], x[b], comp) ? (ArrayBinaryMap.isLess(x[b], x[c], comp) ? b : (ArrayBinaryMap.isLess(x[a], x[c], comp) ? c : a)) : (ArrayBinaryMap.isGreater(x[b], x[c], comp) ? b : (ArrayBinaryMap.isGreater(x[a], x[c], comp) ? c : a));
    }

    private static <T> boolean isLessOrEqual(T a, T b, Comparator<T> comp) {
        return comp.compare(a, b) <= 0;
    }

    private static <T> boolean isLess(T a, T b, Comparator<T> comp) {
        return comp.compare(a, b) < 0;
    }

    private static <T> boolean isGreater(T a, T b, Comparator<T> comp) {
        return comp.compare(a, b) > 0;
    }

    private static <T> boolean isGreaterOrEqual(T a, T b, Comparator<T> comp) {
        return comp.compare(a, b) >= 0;
    }

    private static <T> boolean isEq(T a, T b, Comparator<T> comp) {
        return comp.compare(a, b) == 0;
    }

    final class En
    implements Map.Entry<T, R>,
    Comparable<En> {
        private final int index;

        public En(int index) {
            this.index = index;
        }

        @Override
        public T getKey() {
            return ArrayBinaryMap.this.keys.objs[this.index];
        }

        @Override
        public R getValue() {
            return ArrayBinaryMap.this.vals[this.index];
        }

        @Override
        public R setValue(R value) {
            Object old = ArrayBinaryMap.this.vals[this.index];
            ((ArrayBinaryMap)ArrayBinaryMap.this).vals[this.index] = value;
            return old;
        }

        ArrayBinaryMap<T, R> mp() {
            return ArrayBinaryMap.this;
        }

        @Override
        public int compareTo(En o) {
            if (o == this) {
                return 0;
            }
            if (this.mp() == o.mp()) {
                return Integer.compare(this.index, o.index);
            }
            Object key = ArrayBinaryMap.this.keys.objs[this.index];
            Object other = o.getKey();
            return ArrayBinaryMap.this.keys.comp.compare(key, other);
        }

        public String toString() {
            return this.index + ": " + this.getKey() + " = " + this.getValue();
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (o instanceof Map.Entry) {
                Map.Entry e = (Map.Entry)o;
                return Objects.equals(this.getKey(), e.getKey()) && Objects.equals(this.getValue(), e.getValue());
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.getKey().hashCode() + 23 * this.getValue().hashCode();
        }
    }

    class Keys
    extends ArrayBinarySetMutable<T> {
        public Keys(Comparator<? super T> comp, int initialCapacity, Class<T> type) {
            super(true, comp, initialCapacity, type);
        }

        @Override
        void grow(int newSize) {
            super.grow(newSize);
            Object[] nue = new Object[newSize];
            System.arraycopy(ArrayBinaryMap.this.vals, 0, nue, 0, this.size());
        }

        @Override
        void reSort() {
            System.out.println("resort");
            ArrayBinaryMap.sort(ArrayBinaryMap.this.keys.objs, ArrayBinaryMap.this.vals, 0, ArrayBinaryMap.this.end(), this.comp);
        }

        @Override
        void rangeRemoved(int index, int length, int origEnd) {
            System.out.println("Range removed " + length + " at " + index + " orig end " + origEnd);
            int amt = origEnd - (index + length);
            System.out.println("SLIDE OVER " + (index + length) + " to " + index + " moving " + amt);
            System.arraycopy(this.objs, index + length, this.objs, index, amt);
            System.out.println("KEYS ARE " + this);
            System.out.println("VALS ARE " + Strings.join((char)',', (Object[])ArrayBinaryMap.this.vals));
            System.out.println("NOW: " + ArrayBinaryMap.this);
        }
    }
}

