/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.util.collections;

import com.mastfrog.util.collections.ArrayUtils;
import com.mastfrog.util.collections.CollectionUtils;
import com.mastfrog.util.strings.Strings;
import java.lang.reflect.Array;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.function.Consumer;

final class ArrayBinarySet<T>
extends AbstractSet<T> {
    final boolean comparatorEquality;
    final Comparator<? super T> comp;
    final T[] objs;

    @SafeVarargs
    ArrayBinarySet(boolean check, boolean comparatorEquality, Comparator<? super T> comp, T ... objs) {
        this.comparatorEquality = comparatorEquality;
        this.comp = comp;
        this.objs = check ? ArrayUtils.dedup(objs) : objs;
        Arrays.sort(this.objs, comp);
    }

    @Override
    public Object[] toArray() {
        return (Object[])this.objs.clone();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        if (a.length == this.objs.length) {
            System.arraycopy(this.objs, 0, a, 0, this.objs.length);
            return a;
        }
        a = (Object[])Array.newInstance(a.getClass().getComponentType(), this.objs.length);
        System.arraycopy(this.objs, 0, a, 0, this.objs.length);
        return a;
    }

    @Override
    public void forEach(Consumer<? super T> action) {
        for (int i = 0; i < this.objs.length; ++i) {
            action.accept(this.objs[i]);
        }
    }

    @Override
    public boolean contains(Object o) {
        if (o == null || this.objs.length == 0) {
            return false;
        }
        if (this.objs.getClass().getComponentType().isInstance(o)) {
            return this.binaryComparatorSearch(o);
        }
        return false;
    }

    private boolean binaryComparatorSearch(T o) {
        int start = 0;
        int end = this.objs.length - 1;
        return ArrayBinarySet.binaryComparatorSearch(this.comparatorEquality, o, this.objs, start, end, this.comp) >= 0;
    }

    static <T> int binaryComparatorSearch(boolean comparatorEquality, T o, T[] objs, int start, int end, Comparator<? super T> comp) {
        if (start < 0) {
            throw new IllegalArgumentException("Negative start " + start);
        }
        if (end < 0) {
            throw new IllegalArgumentException("Negative end " + end);
        }
        if (!comparatorEquality) {
            // empty if block
        }
        if (start == end) {
            return -1;
        }
        int startCompare = ArrayBinarySet.compareAt(o, objs, start, comp);
        if (startCompare == 0) {
            return start;
        }
        if (startCompare < 0) {
            return -1;
        }
        int endCompare = ArrayBinarySet.compareAt(o, objs, end, comp);
        if (endCompare == 0) {
            return end;
        }
        if (endCompare > 0) {
            return -1;
        }
        int amt = (end - start + 1) / 2;
        int pos = ArrayBinarySet.binaryComparatorSearch(false, o, objs, start + amt, end, comp);
        if (pos >= 0) {
            return pos;
        }
        return ArrayBinarySet.binaryComparatorSearch(false, o, objs, start, end - amt, comp);
    }

    private static <T> int compareAt(T o, T[] objs, int position, Comparator<T> comp) {
        return comp.compare(o, objs[position]);
    }

    @Override
    public Iterator<T> iterator() {
        return CollectionUtils.toIterator(this.objs);
    }

    @Override
    public int size() {
        return this.objs.length;
    }

    @Override
    public int hashCode() {
        int h = 0;
        for (int i = 0; i < this.objs.length; ++i) {
            h += this.objs[i].hashCode();
        }
        return h;
    }

    @Override
    public String toString() {
        return Strings.join((char)',', (Object[])this.objs).toString();
    }
}

