/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.util.collections;

import com.mastfrog.util.collections.ArrayBinarySet;
import com.mastfrog.util.collections.ArrayUtils;
import com.mastfrog.util.collections.CollectionUtils;
import com.mastfrog.util.preconditions.Checks;
import com.mastfrog.util.strings.Strings;
import java.lang.reflect.Array;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;

class ArrayBinarySetMutable<T>
extends AbstractSet<T> {
    private final boolean comparatorEquality;
    final Comparator<? super T> comp;
    T[] objs;
    private boolean needSort = true;
    int end = -1;
    int modCount;
    private static final int INCREMENT = 10;

    ArrayBinarySetMutable(boolean comparatorEquality, Comparator<? super T> comp, Class<T> type) {
        this(comparatorEquality, comp, 20, type);
    }

    ArrayBinarySetMutable(boolean comparatorEquality, Comparator<? super T> comp, int initialCapacity, Class<T> type) {
        this.comp = comp;
        this.objs = (Object[])Array.newInstance(type, initialCapacity);
        this.comparatorEquality = comparatorEquality;
    }

    @SafeVarargs
    ArrayBinarySetMutable(boolean check, boolean comparatorEquality, Comparator<? super T> comp, T ... objs) {
        this.comparatorEquality = comparatorEquality;
        this.comp = comp;
        this.objs = check ? ArrayUtils.dedup(objs) : objs;
        Arrays.sort(this.objs, comp);
        this.end = objs.length - 1;
    }

    ArrayBinarySetMutable(Collection<T> set, Class<T> type, Comparator<? super T> comp) {
        this(false, true, comp, set.toArray((Object[])Array.newInstance(type, set.size())));
    }

    ArrayBinarySetMutable(Class<T> type, Comparator<? super T> comp) {
        this(true, comp, 10, type);
    }

    ArrayBinarySetMutable(ArrayBinarySet<T> set) {
        this.comparatorEquality = set.comparatorEquality;
        this.objs = ArrayUtils.copyOf(set.objs);
        this.comp = set.comp;
        this.end = set.size() - 1;
        this.needSort = false;
    }

    ArrayBinarySetMutable(ArrayBinarySetMutable<T> set) {
        this.comparatorEquality = set.comparatorEquality;
        this.objs = ArrayUtils.copyOf(set.objs);
        this.comp = set.comp;
        this.end = set.end;
        this.needSort = set.needSort;
    }

    static <T extends Comparable<T>> ArrayBinarySetMutable<T> create(Class<T> type) {
        CollectionUtils.ComparableComparator comp = new CollectionUtils.ComparableComparator();
        return new ArrayBinarySetMutable<T>(type, comp);
    }

    static <T extends Comparable<T>> ArrayBinarySetMutable<T> create(Class<T> type, Collection<T> orig) {
        CollectionUtils.ComparableComparator comp = new CollectionUtils.ComparableComparator();
        return new ArrayBinarySetMutable<T>(orig, type, comp);
    }

    void checkSort() {
        if (this.needSort) {
            this.reSort();
            this.needSort = false;
        }
    }

    void reSort() {
        if (this.end > 0) {
            Arrays.sort(this.objs, 0, this.end + 1, this.comp);
        }
        this.needSort = false;
    }

    private void needSort() {
        ++this.modCount;
        this.needSort = true;
    }

    @Override
    public Object[] toArray() {
        return (Object[])this.objs.clone();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        if (a.length == this.objs.length) {
            System.arraycopy(this.objs, 0, a, 0, this.objs.length);
            return a;
        }
        a = (Object[])Array.newInstance(a.getClass().getComponentType(), this.objs.length);
        System.arraycopy(this.objs, 0, a, 0, this.objs.length);
        return a;
    }

    @Override
    public void forEach(Consumer<? super T> action) {
        for (int i = 0; i <= this.end; ++i) {
            action.accept(this.objs[i]);
        }
    }

    @Override
    public boolean contains(Object o) {
        if (o == null || this.end == -1) {
            return false;
        }
        if (this.objs.getClass().getComponentType().isInstance(o)) {
            if (this.end == 0) {
                return this.comparatorEquality ? this.comp.compare(o, this.objs[0]) == 0 : Objects.equals(o, this.objs[0]);
            }
            this.checkSort();
            return this.binaryComparatorSearch(o);
        }
        return false;
    }

    private boolean binaryComparatorSearch(T o) {
        if (this.end < 0) {
            return false;
        }
        if (this.end == 0) {
            return this.comparatorEquality ? this.comp.compare(o, this.objs[0]) == 0 : Objects.equals(o, this.objs[0]);
        }
        int ix = ArrayBinarySet.binaryComparatorSearch(this.comparatorEquality, o, this.objs, 0, this.end, this.comp);
        return ix >= 0;
    }

    int indexOf(Object key) {
        if (this.objs.getClass().getComponentType().isInstance(key)) {
            return ArrayBinarySet.binaryComparatorSearch(this.comparatorEquality, key, this.objs, 0, this.end, this.comp);
        }
        return -1;
    }

    @Override
    public Iterator<T> iterator() {
        this.checkSort();
        return new It();
    }

    @Override
    public int size() {
        return this.end + 1;
    }

    @Override
    public int hashCode() {
        this.checkSort();
        int h = 0;
        for (int i = 0; i < this.end + 1; ++i) {
            h += this.objs[i].hashCode();
        }
        return h;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i <= this.end; ++i) {
            sb.append(this.objs[i]);
            if (i == this.end) continue;
            sb.append(',');
        }
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        Collection c;
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o instanceof Collection && (c = (Collection)o).size() == this.size()) {
            return this.containsAll(c);
        }
        return false;
    }

    @Override
    public void clear() {
        this.end = -1;
        ++this.modCount;
        Arrays.fill(this.objs, null);
    }

    private void checkSize(int needed) {
        if (this.objs.length < needed) {
            int newSize = (needed % 10 + 1) * 10;
            this.grow(newSize);
        }
    }

    void grow(int newSize) {
        Object[] nue = (Object[])Array.newInstance(this.objs.getClass().getComponentType(), newSize);
        System.arraycopy(this.objs, 0, nue, 0, this.objs.length);
        this.objs = nue;
    }

    boolean greaterThanEnd(T obj) {
        if (this.end == -1) {
            return true;
        }
        T test = this.objs[this.end];
        int comparison = this.comp.compare(obj, test);
        return comparison > 0;
    }

    @Override
    public boolean add(T e) {
        if (e == null) {
            throw new NullPointerException("Nulls not allowed");
        }
        if (this.greaterThanEnd(e)) {
            ++this.end;
            this.checkSize(this.end + 1);
            this.objs[this.end] = e;
            return true;
        }
        if (this.contains(e)) {
            return false;
        }
        this.needSort();
        ++this.end;
        this.checkSize(this.end + 1);
        this.objs[this.end] = e;
        return true;
    }

    void rangeRemoved(int index, int size, int origEnd) {
    }

    @Override
    public boolean remove(Object o) {
        if (o == null || this.end == -1 || !this.objs.getClass().getComponentType().isInstance(o)) {
            return false;
        }
        if (this.end == 0) {
            boolean eq;
            boolean bl = this.comparatorEquality ? this.comp.compare(this.objs[0], o) == 0 : (eq = Objects.equals(o, this.objs[0]));
            if (eq) {
                this.clear();
                return true;
            }
            return false;
        }
        this.checkSort();
        int index = ArrayBinarySet.binaryComparatorSearch(this.comparatorEquality, o, this.objs, 0, this.end, this.comp);
        if (index < 0) {
            return false;
        }
        ++this.modCount;
        System.arraycopy(this.objs, index + 1, this.objs, index, this.end - index);
        this.rangeRemoved(index, 1, this.end);
        --this.end;
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        if (((Collection)Checks.notNull((String)"c", c)).isEmpty()) {
            return false;
        }
        return this.removeIf((Predicate<? super T>)((Predicate<Object>)o -> c.contains(o)));
    }

    @Override
    public boolean removeIf(Predicate<? super T> filter) {
        boolean changed = false;
        int rangeStart = -1;
        int rangeLength = 0;
        boolean anyKeep = false;
        int origEnd = this.end;
        for (int i = this.end; i >= 0; --i) {
            boolean shouldRemove = filter.test(this.objs[i]);
            if (shouldRemove) {
                if (!changed && !anyKeep) {
                    --this.end;
                } else if (rangeStart == -1) {
                    rangeStart = i;
                    rangeLength = 1;
                } else {
                    --rangeStart;
                    ++rangeLength;
                }
            }
            if (!(shouldRemove && i != 0 || rangeStart < 0)) {
                int rangeEnd = rangeStart + rangeLength;
                int dest = shouldRemove ? i : i + 1;
                int num = this.end - rangeEnd + 1;
                System.arraycopy(this.objs, rangeStart + rangeLength, this.objs, dest, num);
                this.rangeRemoved(rangeStart, rangeLength, this.end);
                this.end -= rangeLength;
                rangeStart = -1;
                rangeLength = 0;
                changed = true;
                ++this.modCount;
            }
            anyKeep |= !shouldRemove;
        }
        return changed || this.end != origEnd;
    }

    private boolean eq(T a, T b) {
        return a == null == (b == null) && (this.comparatorEquality ? this.comp.compare(a, b) == 0 : Objects.equals(a, b));
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        Checks.notNull((String)"c", c);
        if (c.isEmpty()) {
            return false;
        }
        Object[] nue = c.toArray((Object[])Array.newInstance(this.objs.getClass().getComponentType(), c.size()));
        if (nue.length == 1) {
            return this.add((T)nue[0]);
        }
        Arrays.sort(nue);
        boolean anyAdded = false;
        int rangeStart = -1;
        int rangeLength = 0;
        int origEnd = this.end;
        Object last = null;
        if (this.end == -1) {
            for (int i = 0; i < nue.length; ++i) {
                Object o = nue[i];
                if (this.eq(last, o)) continue;
                this.objs[++this.end] = o;
                last = o;
            }
            this.needSort();
            return true;
        }
        this.checkSort();
        for (int i = 0; i < nue.length; ++i) {
            boolean skip;
            Object o = nue[i];
            if (o == null) {
                throw new NullPointerException("Null in " + Strings.join((char)',', (Object[])nue));
            }
            int origIndex = origEnd == 0 ? -1 : ArrayBinarySet.binaryComparatorSearch(this.comparatorEquality, o, this.objs, 0, origEnd, this.comp);
            boolean alreadyAdded = this.eq(last, o);
            boolean bl = skip = alreadyAdded || origIndex != -1;
            if (skip || i == nue.length - 1) {
                if (!skip) {
                    ++rangeLength;
                    if (rangeStart == -1) {
                        rangeStart = i;
                    }
                }
                if (rangeLength > 0 && rangeStart != -1) {
                    this.checkSize(this.end + rangeLength + 1);
                    if (rangeLength == 1) {
                        this.objs[this.end + 1] = nue[rangeStart];
                    } else {
                        System.arraycopy(nue, rangeStart, this.objs, this.end + 1, rangeLength);
                    }
                    this.end += rangeLength;
                    rangeStart = -1;
                    rangeLength = 0;
                    anyAdded = true;
                }
            } else {
                ++rangeLength;
                if (rangeStart == -1) {
                    rangeStart = i;
                }
            }
            last = o;
        }
        if (anyAdded) {
            this.needSort();
        }
        return anyAdded;
    }

    @Override
    public boolean isEmpty() {
        return this.end < 0;
    }

    void shiftLeft(int to, int from, int rangeLength) {
        T[] ext = ArrayUtils.extract(this.objs, from, rangeLength);
        System.arraycopy(this.objs, from, this.objs, to, rangeLength);
        this.rangeRemoved(from, from - to, this.end);
        this.end -= from - to;
        assert (this.noDuplicates());
    }

    private boolean noDuplicates() {
        HashSet<T> s = new HashSet<T>();
        for (T key : this) {
            if (s.contains(key)) {
                throw new AssertionError((Object)("Duplicate key " + key + ": " + this));
            }
            s.add(key);
        }
        return true;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean wasEmpty;
        Checks.notNull((String)"c", c);
        boolean bl = wasEmpty = this.end < 0;
        if (c.isEmpty()) {
            this.clear();
            return !wasEmpty;
        }
        boolean changed = false;
        int rangeEnd = -1;
        boolean hasRetained = false;
        for (int i = this.end; i >= 0; --i) {
            T o = this.objs[i];
            boolean retain = c.contains(o);
            if (!retain) {
                if (rangeEnd == -1) {
                    rangeEnd = i;
                }
                if (i == 0) {
                    if (!changed) {
                        this.end = -1;
                        break;
                    }
                    this.shiftLeft(i, rangeEnd + 1, this.end - rangeEnd);
                    changed = true;
                }
            } else if (rangeEnd != -1) {
                if (!changed && !hasRetained) {
                    this.end = i;
                } else {
                    this.shiftLeft(i + 1, rangeEnd + 1, this.end - rangeEnd + 1);
                }
                rangeEnd = -1;
                changed = true;
            }
            hasRetained |= retain;
        }
        return changed;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        Object o;
        super.containsAll(c);
        if (c.isEmpty()) {
            return false;
        }
        if (this.isEmpty()) {
            return false;
        }
        if (this.size() < c.size()) {
            return false;
        }
        boolean result = true;
        Iterator<?> iterator = c.iterator();
        while (iterator.hasNext() && (result = this.contains(o = iterator.next()))) {
        }
        return result;
    }

    class It
    implements Iterator<T> {
        private int ix = -1;
        private int mc;

        It() {
            this.mc = ArrayBinarySetMutable.this.modCount;
        }

        private void checkModification() {
            if (ArrayBinarySetMutable.this.modCount != this.mc) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public boolean hasNext() {
            return this.ix < ArrayBinarySetMutable.this.end;
        }

        @Override
        public void forEachRemaining(Consumer<? super T> action) {
            for (int i = this.ix + 1; i <= ArrayBinarySetMutable.this.end; ++i) {
                action.accept(ArrayBinarySetMutable.this.objs[i]);
            }
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new IndexOutOfBoundsException("" + this.ix);
            }
            this.checkModification();
            return ArrayBinarySetMutable.this.objs[++this.ix];
        }

        public String toString() {
            return "It over " + ArrayBinarySetMutable.this + " at " + this.ix + " hasNext()? " + this.hasNext();
        }

        @Override
        public void remove() {
            this.checkModification();
            System.arraycopy(ArrayBinarySetMutable.this.objs, this.ix + 1, ArrayBinarySetMutable.this.objs, this.ix, ArrayBinarySetMutable.this.end - this.ix);
            ArrayBinarySetMutable.this.rangeRemoved(this.ix, 1, ArrayBinarySetMutable.this.end);
            this.mc = ++ArrayBinarySetMutable.this.modCount;
            ArrayBinarySetMutable.this.objs[ArrayBinarySetMutable.this.end] = null;
            --ArrayBinarySetMutable.this.end;
            --this.ix;
        }
    }
}

