/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.util.collections;

import com.mastfrog.abstractions.list.IndexedResolvable;
import com.mastfrog.util.collections.CollectionUtils;
import java.util.Arrays;
import java.util.List;

final class ArrayIndexedImpl<T extends Comparable<T>>
implements IndexedResolvable<T> {
    private final T[] sorted;
    private final int[] indices;
    private final T[] origOrder;

    @SafeVarargs
    ArrayIndexedImpl(T ... items) {
        this.origOrder = items;
        this.sorted = (Comparable[])Arrays.copyOf(items, items.length);
        Arrays.sort(this.sorted);
        this.indices = new int[items.length];
        List<T> order = Arrays.asList(items);
        CollectionUtils.checkDuplicates(order);
        for (int i = 0; i < items.length; ++i) {
            T s = this.sorted[i];
            this.indices[i] = order.indexOf(s);
        }
    }

    public int size() {
        return this.sorted.length;
    }

    public int indexOf(Object o) {
        int ix = Arrays.binarySearch(this.sorted, o);
        return ix < 0 ? -1 : this.indices[ix];
    }

    public T forIndex(int index) {
        return this.origOrder[index];
    }
}

