/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.util.collections;

import com.mastfrog.util.collections.ArrayBinarySet;
import com.mastfrog.util.collections.CollectionUtils;
import com.mastfrog.util.collections.IntMap;
import com.mastfrog.util.sort.Sort;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.PrimitiveIterator;
import java.util.Set;
import java.util.function.IntConsumer;
import java.util.function.Supplier;

final class ArrayIntMap<T>
implements IntMap<T> {
    private int[] keys;
    private Object[] vals;
    private int last = -1;
    private final Supplier<T> emptyValue;
    private boolean addSuppliedValues;
    int nextKey = 0;
    boolean resort;
    private static final int serialVersionUID = 1;

    private ArrayIntMap(ArrayIntMap<T> other) {
        this.keys = Arrays.copyOf(other.keys, other.keys.length);
        this.vals = Arrays.copyOf(other.vals, other.vals.length);
        this.last = other.last;
        this.emptyValue = other.emptyValue;
        this.resort = other.resort;
        this.nextKey = other.nextKey;
    }

    public ArrayIntMap() {
        this.keys = new int[]{Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE};
        this.vals = new Object[5];
        this.emptyValue = null;
    }

    public ArrayIntMap(int minCapacity) {
        this(minCapacity, true, null);
    }

    public ArrayIntMap(int minCapacity, boolean addSuppliedValues, Supplier<T> emptyValue) {
        if (minCapacity <= 0) {
            throw new IllegalArgumentException("Must be > 0");
        }
        this.addSuppliedValues = addSuppliedValues;
        this.emptyValue = emptyValue;
        this.keys = new int[minCapacity];
        this.vals = new Object[minCapacity];
        Arrays.fill(this.keys, Integer.MAX_VALUE);
    }

    public ArrayIntMap(Map<Integer, T> from) {
        this.emptyValue = null;
        int max = from.size();
        this.keys = new int[max];
        this.vals = new Object[max];
        int index = 0;
        int lastKey = Integer.MIN_VALUE;
        for (Map.Entry<Integer, T> en : from.entrySet()) {
            int key;
            this.keys[index] = key = en.getKey().intValue();
            this.vals[index++] = en.getValue();
            this.resort |= key <= lastKey;
            lastKey = key;
        }
        this.nextKey = max;
        this.last = max - 1;
    }

    ArrayIntMap(int[] keys, Object[] vals) {
        if (keys.length != vals.length) {
            throw new IllegalArgumentException("Key and value array sizes do not match: " + keys.length + " and " + vals.length);
        }
        if (keys.length > 0) {
            int last = -1;
            this.resort = false;
            int max = last;
            for (int i = 0; i < keys.length; ++i) {
                int val = keys[i];
                if (val == last) {
                    throw new IllegalArgumentException("Duplicate keys: " + val);
                }
                if (val < last) {
                    this.resort = true;
                }
                last = val;
                max = Math.max(max, last);
            }
            this.nextKey = max + 1;
            this.keys = Arrays.copyOf(keys, keys.length);
            this.vals = Arrays.copyOf(vals, vals.length);
            this.last = this.vals.length - 1;
            this.emptyValue = null;
        } else {
            this.last = -1;
            this.keys = new int[5];
            this.vals = new Object[5];
            this.nextKey = Integer.MIN_VALUE;
            this.emptyValue = null;
        }
    }

    @Override
    public int[] keysArray() {
        return Arrays.copyOf(this.keys, this.last + 1);
    }

    @Override
    public Object[] valuesArray() {
        return Arrays.copyOf(this.vals, this.last + 1);
    }

    public ArrayIntMap<T> copy() {
        return new ArrayIntMap<T>(this);
    }

    @Override
    public boolean forSomeKeys(IntMap.IntMapAbortableConsumer<? super T> cons) {
        for (int i = 0; i < this.size(); ++i) {
            boolean result = cons.accept(this.keys[i], this.vals[i]);
            if (result) continue;
            return false;
        }
        return true;
    }

    @Override
    public void forEach(IntMap.IntMapConsumer<? super T> cons) {
        for (int i = 0; i < this.size(); ++i) {
            cons.accept(this.keys[i], this.vals[i]);
        }
    }

    public int[] keys() {
        this.checkSort();
        int[] result = new int[this.size()];
        System.arraycopy(this.keys, 0, result, 0, result.length);
        return result;
    }

    @Override
    public int lowestKey() {
        this.checkSort();
        return this.isEmpty() ? -1 : this.keys[0];
    }

    @Override
    public int highestKey() {
        this.checkSort();
        return this.isEmpty() ? -1 : this.keys[this.last];
    }

    int keyForIndex(int ix) {
        return this.keys[ix];
    }

    T forIndex(int ix) {
        return (T)this.vals[ix];
    }

    @Override
    public boolean containsKey(int key) {
        if (key >= this.nextKey) {
            return false;
        }
        if (this.isEmpty()) {
            return false;
        }
        if (this.last == 0) {
            return key == this.keys[0];
        }
        if (this.resort) {
            int max = this.size();
            for (int i = 0; i < max; ++i) {
                if (this.keys[i] != key) continue;
                return true;
            }
            return false;
        }
        if (this.last > -1) {
            this.checkSort();
            if (key < this.keys[0] || key > this.keys[this.last]) {
                return false;
            }
        }
        if (this.emptyValue == null) {
            return this.get(key) != null;
        }
        return this.getIfPresent(key, null) != null;
    }

    @Override
    public int nearest(int key, boolean backward) {
        this.checkSort();
        if (this.isEmpty()) {
            return -1;
        }
        if (this.last == 0) {
            return this.keys[this.last];
        }
        if (key < this.keys[0]) {
            return backward ? this.keys[this.last] : this.keys[0];
        }
        if (key > this.keys[this.last]) {
            return backward ? this.keys[this.last] : this.keys[0];
        }
        int idx = Arrays.binarySearch(this.keys, 0, this.last + 1, key);
        if (idx < 0) {
            if ((idx = -idx + (backward ? -2 : -1)) > this.last) {
                idx = backward ? this.last : 0;
            } else if (idx < 0) {
                idx = backward ? this.last : 0;
            }
        }
        return this.keys[idx];
    }

    @Override
    public int[] getKeys() {
        if (this.last == -1) {
            return new int[0];
        }
        this.checkSort();
        if (this.last == -1) {
            return new int[0];
        }
        if (this.last == this.keys.length - 1) {
            this.growArrays();
        }
        int[] result = new int[this.last + 1];
        try {
            System.arraycopy(this.keys, 0, result, 0, this.last + 1);
            return result;
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            ArrayIndexOutOfBoundsException e = new ArrayIndexOutOfBoundsException("AIOOBE in IntMap.getKeys() - last = " + this.last + " keys: " + ArrayIntMap.i2s(this.keys) + " vals: " + Arrays.asList(this.vals) + " result length " + result.length);
            e.initCause(aioobe);
            throw e;
        }
    }

    private static String i2s(int[] arr) {
        StringBuilder sb = new StringBuilder(arr.length * 3 + 2);
        sb.append('[');
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i] == Integer.MAX_VALUE) continue;
            sb.append(arr[i]);
            sb.append(',');
        }
        sb.append(']');
        return sb.toString();
    }

    @Override
    public T getIfPresent(int key, T defaultValue) {
        if (this.last < 0) {
            return defaultValue;
        }
        if (this.last == 0) {
            if (key == this.keys[0]) {
                return (T)this.vals[0];
            }
            return defaultValue;
        }
        this.checkSort();
        int idx = Arrays.binarySearch(this.keys, 0, this.last + 1, key);
        Object result = null;
        result = idx > -1 && idx <= this.last ? this.vals[idx] : (Object)defaultValue;
        return (T)result;
    }

    @Override
    public T get(int key) {
        if (this.last < 0) {
            T result = null;
            if (this.emptyValue != null && (result = (T)this.emptyValue.get()) != null && this.addSuppliedValues) {
                this.last = 0;
                this.keys[0] = key;
                this.vals[0] = result;
                this.nextKey = Math.max(this.nextKey, key + 1);
            }
            return result;
        }
        if (this.last == 0) {
            if (key == this.keys[0]) {
                return (T)this.vals[0];
            }
            if (this.emptyValue != null) {
                T result = this.emptyValue.get();
                if (result != null && this.addSuppliedValues) {
                    this.put(key, result);
                }
                return result;
            }
            return null;
        }
        this.checkSort();
        int idx = Arrays.binarySearch(this.keys, 0, this.last + 1, key);
        Object result = null;
        if (idx > -1 && idx <= this.last) {
            result = this.vals[idx];
        }
        if (result == null && this.emptyValue != null && this.addSuppliedValues) {
            result = this.emptyValue.get();
            if (result != null) {
                this.put(key, (T)result);
            }
            return (T)result;
        }
        return (T)(result == null ? (this.emptyValue == null ? null : this.emptyValue.get()) : result);
    }

    @Override
    public T put(int key, T val) {
        int existingIndex;
        boolean between = false;
        if (this.last >= 0) {
            if (this.keys[this.last] == key && this.vals[this.last] == val) {
                return val;
            }
            if (this.keys[this.last] == key) {
                Object old = this.vals[this.last];
                this.vals[this.last] = val;
                return (T)old;
            }
            if (key < this.keys[this.last]) {
                this.resort = true;
                between = key >= this.keys[0];
            } else if (key == this.keys[this.last]) {
                between = true;
            }
        }
        if (between && (existingIndex = Arrays.binarySearch(this.keys, 0, this.last + 1, key)) >= 0) {
            Object old = this.vals[existingIndex];
            this.vals[existingIndex] = val;
            return (T)old;
        }
        if (this.last == this.keys.length - 1) {
            this.growArrays();
        }
        ++this.last;
        this.nextKey = Math.max(key + 1, this.nextKey);
        this.keys[this.last] = key;
        this.vals[this.last] = val;
        return null;
    }

    void checkSort() {
        if (this.resort) {
            this.sort();
            this.resort = false;
        }
    }

    private void growArrays() {
        int newSize = this.last < 250 ? this.last + Math.max(5, this.last + this.last / 3) : this.last + this.last / 2;
        int[] newKeys = new int[newSize];
        Object[] newVals = new Object[newSize];
        System.arraycopy(this.keys, 0, newKeys, 0, this.keys.length);
        System.arraycopy(this.vals, 0, newVals, 0, this.vals.length);
        Arrays.fill(newKeys, this.keys.length, newKeys.length, Integer.MAX_VALUE);
        this.keys = newKeys;
        this.vals = newVals;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        int[] ints = this.keys.length == this.size() ? this.keys : Arrays.copyOf(this.keys, this.size());
        Object[] vals = this.vals.length == this.size() ? this.vals : Arrays.copyOf(this.vals, this.size());
        out.writeObject(ints);
        out.writeObject(vals);
        out.writeBoolean(this.resort);
        out.writeInt(this.nextKey);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int[] keys = (int[])in.readObject();
        Object[] vals = (Object[])in.readObject();
        this.resort = in.readBoolean();
        this.nextKey = in.readInt();
        this.last = keys.length - 1;
        if (keys.length != vals.length) {
            throw new IOException("Different lengths arrays");
        }
        this.keys = keys;
        this.vals = vals;
    }

    public int nextEntry(int entry) {
        int idx;
        if (this.last < 0) {
            return -1;
        }
        if (entry > this.keys[this.last]) {
            return -1;
        }
        this.checkSort();
        int result = -1;
        if (!this.isEmpty() && (idx = Arrays.binarySearch(this.keys, 0, this.last + 1, entry)) >= 0) {
            result = idx == this.keys.length - 1 ? this.keys[0] : this.keys[idx + 1];
        }
        return result;
    }

    public int prevEntry(int entry) {
        int idx;
        if (this.last < 0) {
            return -1;
        }
        if (entry < this.keys[0]) {
            return -1;
        }
        this.checkSort();
        int result = -1;
        if (!this.isEmpty() && (idx = Arrays.binarySearch(this.keys, 0, this.last + 1, entry)) >= 0) {
            result = idx == -1 ? this.keys[this.keys.length - 1] : this.keys[idx - 1];
        }
        return result;
    }

    @Override
    public boolean isEmpty() {
        return this.last == -1;
    }

    @Override
    public int size() {
        return this.last + 1;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.size() * 8).append('{');
        int sz = this.size();
        for (int i = 0; i < sz; ++i) {
            sb.append(this.keys[i]);
            sb.append("=");
            sb.append(this.vals[i]);
            if (i == sz - 1) continue;
            sb.append(", ");
        }
        return sb.append('}').toString();
    }

    @Override
    public void decrementKeys(int decrement) {
        this.checkSort();
        if (decrement < 0) {
            throw new IllegalArgumentException();
        }
        int shift = Arrays.binarySearch(this.keys, 0, this.last + 1, decrement);
        if (shift < 0) {
            shift = -shift - 1;
        }
        for (int i = shift; i <= this.last; ++i) {
            this.keys[i - shift] = this.keys[i] - decrement;
            this.vals[i - shift] = this.vals[i];
        }
        Arrays.fill(this.keys, this.last - shift + 1, this.last + 1, Integer.MAX_VALUE);
        this.last -= shift;
    }

    @Override
    public Iterable<Map.Entry<Integer, T>> entries() {
        return this;
    }

    @Override
    public Iterator<Map.Entry<Integer, T>> iterator() {
        if (this.isEmpty()) {
            return Collections.emptyIterator();
        }
        this.checkSort();
        return new Iter();
    }

    public Iterable<T> valuesIterable() {
        if (this.isEmpty()) {
            return Collections.emptyList();
        }
        this.checkSort();
        return () -> new ArrIter();
    }

    @Override
    public boolean containsKey(Object key) {
        if (key instanceof Integer) {
            int keyVal = (Integer)key;
            return this.containsKey(keyVal);
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        for (int i = 0; i <= this.last; ++i) {
            if (!Objects.equals(value, this.vals[i])) continue;
            return true;
        }
        return false;
    }

    int keyForValue(Object value) {
        for (int i = 0; i <= this.last; ++i) {
            if (!Objects.equals(value, this.vals[i])) continue;
            return this.keys[i];
        }
        return -1;
    }

    @Override
    public T get(Object key) {
        if (key instanceof Integer) {
            return this.get((Integer)key);
        }
        return null;
    }

    @Override
    public T put(Integer key, T value) {
        if (key == null) {
            throw new IllegalArgumentException("Null not allowed as a key");
        }
        return this.put((int)key, value);
    }

    @Override
    public T remove(int keyVal) {
        if (this.last >= 0 && keyVal == this.keys[this.last]) {
            Object old = this.vals[this.last];
            this.vals[this.last] = null;
            --this.last;
            return (T)old;
        }
        int index = Arrays.binarySearch(this.keys, 0, this.last + 1, keyVal);
        if (index >= 0) {
            Object result = this.vals[index];
            if (index == 0) {
                int[] newKeys = new int[this.keys.length];
                Object[] newVals = new Object[this.vals.length];
                System.arraycopy(this.keys, 1, newKeys, 0, this.keys.length - 1);
                System.arraycopy(this.vals, 1, newVals, 0, this.vals.length - 1);
                newKeys[newKeys.length - 1] = Integer.MAX_VALUE;
                --this.last;
                this.keys = newKeys;
                this.vals = newVals;
            } else {
                if (index == this.last) {
                    this.keys[this.last] = Integer.MAX_VALUE;
                    this.vals[this.last] = null;
                    --this.last;
                    return (T)result;
                }
                int[] newKeys = new int[this.keys.length];
                Object[] newVals = new Object[this.vals.length];
                System.arraycopy(this.keys, 0, newKeys, 0, index);
                System.arraycopy(this.vals, 0, newVals, 0, index);
                System.arraycopy(this.keys, index + 1, newKeys, index, this.keys.length - (index + 1));
                System.arraycopy(this.vals, index + 1, newVals, index, this.vals.length - (index + 1));
                newKeys[newKeys.length - 1] = Integer.MAX_VALUE;
                newVals[newVals.length - 1] = null;
                --this.last;
                this.keys = newKeys;
                this.vals = newVals;
            }
            return (T)result;
        }
        return null;
    }

    @Override
    public T remove(Object key) {
        if (this.last == -1) {
            return null;
        }
        if (key instanceof Integer) {
            int keyVal = (Integer)key;
            return this.remove(keyVal);
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends Integer, ? extends T> m) {
        for (Map.Entry<Integer, T> e : m.entrySet()) {
            int k = e.getKey();
            this.put(k, e.getValue());
        }
    }

    @Override
    public void clear() {
        this.last = -1;
        Arrays.fill(this.keys, Integer.MAX_VALUE);
        Arrays.fill(this.vals, null);
    }

    @Override
    public Set<Integer> keySet() {
        return new KeySet();
    }

    @Override
    public PrimitiveIterator.OfInt keysIterator() {
        return new KeyIter();
    }

    @Override
    public void forEachKey(IntConsumer cons) {
        for (int i = 0; i <= this.last; ++i) {
            cons.accept(this.keys[i]);
        }
    }

    @Override
    public Collection<T> values() {
        return new ValueCollection();
    }

    @Override
    public Set<Map.Entry<Integer, T>> entrySet() {
        int max = this.size();
        ME[] mes = (ME[])Array.newInstance(ME.class, max);
        for (int i = 0; i < max; ++i) {
            mes[i] = new ME(i);
        }
        return new ArrayBinarySet<Map.Entry<Integer, T>>(false, false, new CollectionUtils.ComparableComparator(), mes);
    }

    @Override
    public int hashCode() {
        int h = 0;
        for (int i = 0; i <= this.last; ++i) {
            h += this.keys[i] ^ (this.vals[i] == null ? 0 : this.vals[i].hashCode());
        }
        return h;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o instanceof Map && ((Map)o).size() == this.size()) {
            for (Map.Entry e : ((Map)o).entrySet()) {
                if (!(e.getKey() instanceof Integer)) continue;
                return Objects.equals(e.getValue(), this.get(e.getKey()));
            }
        }
        return false;
    }

    private void sort() {
        Sort.biSort(this.keys, this.vals, this.size());
    }

    class ValueCollection
    implements Collection<T> {
        ValueCollection() {
        }

        @Override
        public int size() {
            return ArrayIntMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return ArrayIntMap.this.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            for (int i = 0; i < this.size(); ++i) {
                if (!Objects.equals(ArrayIntMap.this.vals[i], o)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Iterator<T> iterator() {
            return new ValsIter();
        }

        @Override
        public Object[] toArray() {
            Object[] nue = new Object[this.size()];
            System.arraycopy(ArrayIntMap.this.vals, 0, nue, 0, nue.length);
            return nue;
        }

        @Override
        public <T> T[] toArray(T[] a) {
            if (a.length != this.size()) {
                a = (Object[])Array.newInstance(a.getClass().getComponentType(), this.size());
            }
            System.arraycopy(ArrayIntMap.this.vals, 0, a, 0, a.length);
            return a;
        }

        @Override
        public boolean add(T e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends T> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object o) {
            Collection c;
            if (o instanceof Collection && (c = (Collection)o).size() == this.size()) {
                for (Object o1 : c) {
                    if (this.contains(o1)) continue;
                    return false;
                }
            }
            return false;
        }

        @Override
        public int hashCode() {
            int hashCode = 1;
            for (int i = 0; i <= ArrayIntMap.this.last; ++i) {
                hashCode = 31 * hashCode + (ArrayIntMap.this.vals[i] == null ? 0 : ArrayIntMap.this.vals[i].hashCode());
            }
            return hashCode;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("[");
            for (int i = 0; i <= ArrayIntMap.this.last; ++i) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(ArrayIntMap.this.vals[i]);
            }
            return sb.append(']').toString();
        }
    }

    class ValsIter
    implements Iterator<T> {
        int ix = -1;

        ValsIter() {
        }

        @Override
        public boolean hasNext() {
            if (ArrayIntMap.this.resort) {
                throw new ConcurrentModificationException();
            }
            return this.ix < ArrayIntMap.this.size() - 1;
        }

        @Override
        public T next() {
            if (ArrayIntMap.this.resort) {
                throw new ConcurrentModificationException();
            }
            return ArrayIntMap.this.vals[++this.ix];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class KeySet
    implements Set<Integer> {
        private KeySet() {
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(this.size() * 3).append('[');
            for (int i = 0; i < ArrayIntMap.this.last + 1; ++i) {
                sb.append(ArrayIntMap.this.keys[i]);
                if (i == ArrayIntMap.this.last) continue;
                sb.append(", ");
            }
            return sb.append(']').toString();
        }

        @Override
        public int size() {
            return ArrayIntMap.this.last + 1;
        }

        @Override
        public boolean isEmpty() {
            return ArrayIntMap.this.last == -1;
        }

        @Override
        public boolean contains(Object o) {
            return ArrayIntMap.this.containsKey(o);
        }

        @Override
        public Iterator<Integer> iterator() {
            return new KeyIter();
        }

        ArrayIntMap map() {
            return ArrayIntMap.this;
        }

        @Override
        public boolean equals(Object o) {
            if (o != null && o.getClass() == this.getClass()) {
                return ((KeySet)o).map() == this.map();
            }
            if (o instanceof Collection && this.size() == ((Collection)o).size()) {
                for (Object o1 : (Collection)o) {
                    if (this.contains(o1)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        @Override
        public int hashCode() {
            int h = 0;
            for (int i = 0; i <= ArrayIntMap.this.last; ++i) {
                h += ArrayIntMap.this.keys[i];
            }
            return h;
        }

        @Override
        public Object[] toArray() {
            Object[] result = new Object[ArrayIntMap.this.last + 1];
            for (int i = 0; i <= ArrayIntMap.this.last; ++i) {
                result[i] = ArrayIntMap.this.keys[i];
            }
            return result;
        }

        @Override
        public <T> T[] toArray(T[] a) {
            if (a.length != ArrayIntMap.this.last + 1) {
                a = (Object[])Array.newInstance(a.getClass().getComponentType(), ArrayIntMap.this.last + 1);
            }
            for (int i = 0; i < a.length; ++i) {
                a[i] = ArrayIntMap.this.keys[i];
            }
            return a;
        }

        @Override
        public boolean add(Integer e) {
            throw new UnsupportedOperationException("Not supported");
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException("Not supported");
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            for (Object o : c) {
                if (ArrayIntMap.this.containsKey(o)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean addAll(Collection<? extends Integer> c) {
            throw new UnsupportedOperationException("Not supported");
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException("Not supported");
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException("Not supported");
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException("Not supported");
        }
    }

    private class ME
    implements Map.Entry<Integer, T>,
    Comparable<ME> {
        private final int ix;

        public ME(int ix) {
            this.ix = ix;
        }

        @Override
        public Integer getKey() {
            return ArrayIntMap.this.keys[this.ix];
        }

        @Override
        public T getValue() {
            return ArrayIntMap.this.vals[this.ix];
        }

        @Override
        public T setValue(T v) {
            Object old = ArrayIntMap.this.vals[this.ix];
            ((ArrayIntMap)ArrayIntMap.this).vals[this.ix] = v;
            return old;
        }

        public String toString() {
            return "ME-" + this.ix + " " + this.getKey() + " = " + this.getValue() + " of " + ArrayIntMap.this.size();
        }

        ArrayIntMap map() {
            return ArrayIntMap.this;
        }

        @Override
        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (o == this) {
                return true;
            }
            if (o.getClass() == this.getClass()) {
                return ((ME)o).map() == this.map() && ((ME)o).ix == this.ix;
            }
            if (o instanceof Map.Entry) {
                Map.Entry other = (Map.Entry)o;
                return Objects.equals(this.getKey(), other.getKey()) && Objects.equals(this.getValue(), other.getValue());
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.ix;
        }

        @Override
        public int compareTo(ME o) {
            return Integer.compare(this.ix, o.ix);
        }
    }

    private class Iter
    implements Iterator<Map.Entry<Integer, T>> {
        int ix = -1;

        private Iter() {
        }

        @Override
        public boolean hasNext() {
            return this.ix < ArrayIntMap.this.size() - 1;
        }

        @Override
        public Map.Entry<Integer, T> next() {
            return new ME(++this.ix);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported");
        }
    }

    private class ArrIter
    implements Iterator<T> {
        private int ix = -1;

        private ArrIter() {
        }

        @Override
        public boolean hasNext() {
            return this.ix < ArrayIntMap.this.size() - 1;
        }

        @Override
        public T next() {
            return ArrayIntMap.this.vals[++this.ix];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported.");
        }
    }

    private class KeyIter
    implements Iterator<Integer>,
    PrimitiveIterator.OfInt {
        private int ix = -1;

        KeyIter() {
            ArrayIntMap.this.checkSort();
        }

        @Override
        public boolean hasNext() {
            if (ArrayIntMap.this.resort) {
                throw new ConcurrentModificationException();
            }
            return this.ix < ArrayIntMap.this.size() - 1;
        }

        @Override
        public Integer next() {
            return this.nextInt();
        }

        @Override
        public int nextInt() {
            return ArrayIntMap.this.keys[++this.ix];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

