/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.util.collections;

import com.mastfrog.util.collections.ArrayUtils;
import com.mastfrog.util.collections.CollectionUtils;
import com.mastfrog.util.strings.Strings;
import java.lang.reflect.Array;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Consumer;

final class ArraySet<T>
extends AbstractSet<T> {
    private final T[] objs;

    @SafeVarargs
    ArraySet(boolean check, T ... objs) {
        this.objs = check ? ArrayUtils.dedup(objs) : objs;
    }

    @Override
    public Object[] toArray() {
        return (Object[])this.objs.clone();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        if (a.length == this.objs.length) {
            System.arraycopy(this.objs, 0, a, 0, this.objs.length);
            return a;
        }
        a = (Object[])Array.newInstance(a.getClass().getComponentType(), this.objs.length);
        System.arraycopy(this.objs, 0, a, 0, this.objs.length);
        return a;
    }

    @Override
    public void forEach(Consumer<? super T> action) {
        for (int i = 0; i < this.objs.length; ++i) {
            action.accept(this.objs[i]);
        }
    }

    @Override
    public boolean contains(Object o) {
        for (int i = 0; i < this.objs.length; ++i) {
            if (!Objects.equals(o, this.objs[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<T> iterator() {
        return CollectionUtils.toIterator(this.objs);
    }

    @Override
    public int size() {
        return this.objs.length;
    }

    @Override
    public int hashCode() {
        int h = 0;
        for (int i = 0; i < this.objs.length; ++i) {
            h += this.objs[i].hashCode();
        }
        return h;
    }

    @Override
    public String toString() {
        return Strings.join((char)',', (Object[])this.objs).toString();
    }
}

