/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.util.collections;

import com.mastfrog.util.collections.CollectionUtils;
import com.mastfrog.util.preconditions.Checks;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.function.DoubleUnaryOperator;

public final class ArrayUtils {
    private static final Object[] EMPTY = new Object[0];

    private ArrayUtils() {
        throw new AssertionError();
    }

    public static Object[] emptyForNull(Object[] array) {
        return array == null ? EMPTY : array;
    }

    public static <T> T[] concatenate(T[] a, T[] b) {
        Object[] nue = (Object[])Array.newInstance(a.getClass().getComponentType(), a.length + b.length);
        System.arraycopy(a, 0, nue, 0, a.length);
        System.arraycopy(b, 0, nue, a.length, b.length);
        return nue;
    }

    public static <T> T[] concatenate(T[] a, T[] b, T[] ... cs) {
        int total = a.length + b.length;
        Class<?> compType = null;
        for (int i = 0; i < cs.length; ++i) {
            T[] c = cs[i];
            total += c.length;
            if (compType == null) {
                compType = c.getClass().getComponentType();
                continue;
            }
            Class<?> currType = c.getClass().getComponentType();
            if (compType == currType) continue;
            throw new IllegalArgumentException("Arrays passed to ArrayUtils.concatenate() must have the same *exact* component type, but found " + compType + " at 0 and " + currType + " at " + i);
        }
        ?[] result = CollectionUtils.genericArray(a.getClass().getComponentType(), total);
        int pos = 0;
        System.arraycopy(a, pos, result, 0, a.length);
        System.arraycopy(b, 0, result, pos += a.length, b.length);
        pos += b.length;
        for (T[] c : cs) {
            System.arraycopy(c, 0, result, pos, c.length);
            pos += c.length;
        }
        return result;
    }

    public static byte[][] split(byte[] arr, int splitPoint) {
        Checks.greaterThanZero((String)"splitPoint", (int)splitPoint);
        Checks.notNull((String)"arr", (Object)arr);
        if (splitPoint >= arr.length) {
            throw new IllegalArgumentException("splitPoint - " + splitPoint + " must be < the array's length of " + arr.length);
        }
        byte[] a = new byte[splitPoint];
        byte[] b = new byte[arr.length - splitPoint];
        System.arraycopy(arr, 0, a, 0, splitPoint);
        System.arraycopy(arr, splitPoint, b, 0, b.length);
        return new byte[][]{a, b};
    }

    public static byte[][] split(byte[] arr, int splitPoint1, int splitPoint2) {
        Checks.greaterThanZero((String)"splitPoint1", (int)splitPoint1);
        Checks.greaterThanZero((String)"splitPoint2", (int)splitPoint2);
        if (splitPoint2 <= splitPoint1) {
            throw new IllegalArgumentException("splitPoint2 must be > splitPoint1: " + splitPoint1 + "," + splitPoint2);
        }
        if (splitPoint1 >= ((byte[])Checks.notNull((String)"arr", (Object)arr)).length) {
            throw new IllegalArgumentException("splitPoint1 - " + splitPoint1 + " - is greater than the array size of " + arr.length);
        }
        if (splitPoint2 >= arr.length) {
            throw new IllegalArgumentException("splitPoint2 - " + splitPoint2 + " - is greater than the array size of " + arr.length);
        }
        byte[] a = new byte[splitPoint1];
        byte[] b = new byte[splitPoint2 - splitPoint1];
        byte[] c = new byte[arr.length - splitPoint2];
        System.arraycopy(arr, 0, a, 0, splitPoint1);
        System.arraycopy(arr, splitPoint1, b, 0, b.length);
        System.arraycopy(arr, splitPoint2, c, 0, c.length);
        return new byte[][]{a, b, c};
    }

    public static byte[][] split(byte[] arr, int splitPoint1, int splitPoint2, int splitPoint3, int ... more) {
        Checks.greaterThanZero((String)"splitPoint1", (int)splitPoint1);
        Checks.greaterThanZero((String)"splitPoint2", (int)splitPoint2);
        if (splitPoint2 <= splitPoint1) {
            throw new IllegalArgumentException("splitPoint2 must be > splitPoint1: " + splitPoint1 + "," + splitPoint2);
        }
        if (splitPoint1 >= ((byte[])Checks.notNull((String)"arr", (Object)arr)).length) {
            throw new IllegalArgumentException("splitPoint1 - " + splitPoint1 + " - is greater than the array size of " + arr.length);
        }
        if (splitPoint2 >= arr.length) {
            throw new IllegalArgumentException("splitPoint2 - " + splitPoint2 + " - is greater than the array size of " + arr.length);
        }
        byte[] a = new byte[splitPoint1];
        byte[] b = new byte[splitPoint2 - splitPoint1];
        byte[] c = new byte[splitPoint3 - splitPoint2];
        byte[] d = new byte[(more.length > 0 ? more[0] : arr.length) - splitPoint3];
        System.arraycopy(arr, 0, a, 0, splitPoint1);
        System.arraycopy(arr, splitPoint1, b, 0, b.length);
        System.arraycopy(arr, splitPoint2, c, 0, c.length);
        System.arraycopy(arr, splitPoint3, d, 0, d.length);
        if (more.length == 0) {
            return new byte[][]{a, b, c, d};
        }
        ArrayList<Object> all = new ArrayList<Object>(4 + more.length);
        all.addAll(Arrays.asList(a, b, c, d));
        for (int i = 1; i < more.length; ++i) {
            byte[] nue = new byte[more[i] - more[i - 1]];
            System.arraycopy(arr, more[i - 1], nue, 0, nue.length);
            all.add(nue);
            if (i != more.length - 1 || arr.length - more[i] <= 0) continue;
            nue = new byte[arr.length - more[i]];
            System.arraycopy(arr, more[i], nue, 0, nue.length);
            all.add(nue);
        }
        return (byte[][])all.toArray((T[])new byte[all.size()][]);
    }

    public static double[][] split(double[] arr, int splitPoint) {
        Checks.greaterThanZero((String)"splitPoint", (int)splitPoint);
        Checks.notNull((String)"arr", (Object)arr);
        if (splitPoint >= arr.length) {
            throw new IllegalArgumentException("splitPoint - " + splitPoint + " must be < the array's length of " + arr.length);
        }
        double[] a = new double[splitPoint];
        double[] b = new double[arr.length - splitPoint];
        System.arraycopy(arr, 0, a, 0, splitPoint);
        System.arraycopy(arr, splitPoint, b, 0, b.length);
        return new double[][]{a, b};
    }

    public static double[][] split(double[] arr, int splitPoint1, int splitPoint2) {
        Checks.greaterThanZero((String)"splitPoint1", (int)splitPoint1);
        Checks.greaterThanZero((String)"splitPoint2", (int)splitPoint2);
        if (splitPoint2 <= splitPoint1) {
            throw new IllegalArgumentException("splitPoint2 must be > splitPoint1: " + splitPoint1 + "," + splitPoint2);
        }
        if (splitPoint1 >= ((double[])Checks.notNull((String)"arr", (Object)arr)).length) {
            throw new IllegalArgumentException("splitPoint1 - " + splitPoint1 + " - is greater than the array size of " + arr.length);
        }
        if (splitPoint2 >= arr.length) {
            throw new IllegalArgumentException("splitPoint2 - " + splitPoint2 + " - is greater than the array size of " + arr.length);
        }
        double[] a = new double[splitPoint1];
        double[] b = new double[splitPoint2 - splitPoint1];
        double[] c = new double[arr.length - splitPoint2];
        System.arraycopy(arr, 0, a, 0, splitPoint1);
        System.arraycopy(arr, splitPoint1, b, 0, b.length);
        System.arraycopy(arr, splitPoint2, c, 0, c.length);
        return new double[][]{a, b, c};
    }

    public static double[][] split(double[] arr, int splitPoint1, int splitPoint2, int splitPoint3, int ... more) {
        Checks.greaterThanZero((String)"splitPoint1", (int)splitPoint1);
        Checks.greaterThanZero((String)"splitPoint2", (int)splitPoint2);
        if (splitPoint2 <= splitPoint1) {
            throw new IllegalArgumentException("splitPoint2 must be > splitPoint1: " + splitPoint1 + "," + splitPoint2);
        }
        if (splitPoint1 >= ((double[])Checks.notNull((String)"arr", (Object)arr)).length) {
            throw new IllegalArgumentException("splitPoint1 - " + splitPoint1 + " - is greater than the array size of " + arr.length);
        }
        if (splitPoint2 >= arr.length) {
            throw new IllegalArgumentException("splitPoint2 - " + splitPoint2 + " - is greater than the array size of " + arr.length);
        }
        double[] a = new double[splitPoint1];
        double[] b = new double[splitPoint2 - splitPoint1];
        double[] c = new double[splitPoint3 - splitPoint2];
        double[] d = new double[(more.length > 0 ? more[0] : arr.length) - splitPoint3];
        System.arraycopy(arr, 0, a, 0, splitPoint1);
        System.arraycopy(arr, splitPoint1, b, 0, b.length);
        System.arraycopy(arr, splitPoint2, c, 0, c.length);
        System.arraycopy(arr, splitPoint3, d, 0, d.length);
        if (more.length == 0) {
            return new double[][]{a, b, c, d};
        }
        ArrayList<Object> all = new ArrayList<Object>(4 + more.length);
        all.addAll(Arrays.asList(a, b, c, d));
        for (int i = 1; i < more.length; ++i) {
            double[] nue = new double[more[i] - more[i - 1]];
            System.arraycopy(arr, more[i - 1], nue, 0, nue.length);
            all.add(nue);
            if (i != more.length - 1 || arr.length - more[i] <= 0) continue;
            nue = new double[arr.length - more[i]];
            System.arraycopy(arr, more[i], nue, 0, nue.length);
            all.add(nue);
        }
        return (double[][])all.toArray((T[])new double[all.size()][]);
    }

    public static byte[] concatenate(byte[] a, byte[] b, byte[] ... cs) {
        int total = a.length + b.length;
        for (byte[] c : cs) {
            total += c.length;
        }
        byte[] result = new byte[total];
        int pos = 0;
        System.arraycopy(a, pos, result, 0, a.length);
        System.arraycopy(b, 0, result, pos += a.length, b.length);
        pos += b.length;
        for (byte[] c : cs) {
            System.arraycopy(c, 0, result, pos, c.length);
            pos += c.length;
        }
        return result;
    }

    public static long[] concatenate(long[] a, long[] b, long[] ... cs) {
        int total = a.length + b.length;
        for (long[] c : cs) {
            total += c.length;
        }
        long[] result = new long[total];
        int pos = 0;
        System.arraycopy(a, pos, result, 0, a.length);
        System.arraycopy(b, 0, result, pos += a.length, b.length);
        pos += b.length;
        for (long[] c : cs) {
            System.arraycopy(c, 0, result, pos, c.length);
            pos += c.length;
        }
        return result;
    }

    public static int[] concatenate(int[] a, int[] b, int[] ... cs) {
        int total = a.length + b.length;
        for (int[] c : cs) {
            total += c.length;
        }
        int[] result = new int[total];
        int pos = 0;
        System.arraycopy(a, pos, result, 0, a.length);
        System.arraycopy(b, 0, result, pos += a.length, b.length);
        pos += b.length;
        for (int[] c : cs) {
            System.arraycopy(c, 0, result, pos, c.length);
            pos += c.length;
        }
        return result;
    }

    public static float[] concatenate(float[] a, float[] b, float[] ... cs) {
        int total = a.length + b.length;
        for (float[] c : cs) {
            total += c.length;
        }
        float[] result = new float[total];
        int pos = 0;
        System.arraycopy(a, pos, result, 0, a.length);
        System.arraycopy(b, 0, result, pos += a.length, b.length);
        pos += b.length;
        for (float[] c : cs) {
            System.arraycopy(c, 0, result, pos, c.length);
            pos += c.length;
        }
        return result;
    }

    public static double[] concatenate(double[] a, double[] b, double[] ... cs) {
        int total = a.length + b.length;
        for (double[] c : cs) {
            total += c.length;
        }
        double[] result = new double[total];
        int pos = 0;
        System.arraycopy(a, pos, result, 0, a.length);
        System.arraycopy(b, 0, result, pos += a.length, b.length);
        pos += b.length;
        for (double[] c : cs) {
            System.arraycopy(c, 0, result, pos, c.length);
            pos += c.length;
        }
        return result;
    }

    public static byte[] concatenate(byte[] a, byte[] b) {
        byte[] nue = new byte[a.length + b.length];
        System.arraycopy(a, 0, nue, 0, a.length);
        System.arraycopy(b, 0, nue, a.length, b.length);
        return nue;
    }

    public static int[] concatenate(int[] a, int[] b) {
        int[] nue = new int[a.length + b.length];
        System.arraycopy(a, 0, nue, 0, a.length);
        System.arraycopy(b, 0, nue, a.length, b.length);
        return nue;
    }

    public static double[] concatenate(double[] a, double[] b) {
        double[] nue = new double[a.length + b.length];
        System.arraycopy(a, 0, nue, 0, a.length);
        System.arraycopy(b, 0, nue, a.length, b.length);
        return nue;
    }

    public static float[] concatenate(float[] a, float[] b) {
        float[] nue = new float[a.length + b.length];
        System.arraycopy(a, 0, nue, 0, a.length);
        System.arraycopy(b, 0, nue, a.length, b.length);
        return nue;
    }

    public static long[] concatenate(long[] a, long[] b) {
        long[] nue = new long[a.length + b.length];
        System.arraycopy(a, 0, nue, 0, a.length);
        System.arraycopy(b, 0, nue, a.length, b.length);
        return nue;
    }

    public static Object[] concatenateAll(Object[] a, Object[] ... b) {
        int total = a.length;
        for (int i = 0; i < b.length; ++i) {
            if (b[i] == null) continue;
            total += b[i].length;
        }
        Object[] result = new Object[total];
        System.arraycopy(a, 0, result, 0, a.length);
        int cursor = a.length;
        for (int i = 0; i < b.length; ++i) {
            if (b[i] == null) continue;
            System.arraycopy(b[i], 0, result, cursor, b[i].length);
            cursor += b[i].length;
        }
        return result;
    }

    public static <T> T[] dedup(T[] a) {
        LinkedHashSet<Object> result = new LinkedHashSet<Object>(Arrays.asList(a));
        if (result.size() == a.length) {
            return a;
        }
        return result.toArray((Object[])Array.newInstance(a.getClass().getComponentType(), result.size()));
    }

    public static Object[] dedupByType(Object[] a) {
        ArrayList<Object> result = new ArrayList<Object>();
        HashSet types = new HashSet();
        for (int i = a.length - 1; i >= 0; --i) {
            if (a[i] == null || types.contains(a[i].getClass())) continue;
            types.add(a[i].getClass());
            result.add(a[i]);
        }
        Collections.reverse(result);
        return result.toArray();
    }

    public static Object[] flatten(Object[] o) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (int i = 0; i < o.length; ++i) {
            if (o[i].getClass().isArray()) {
                ArrayUtils.dumpArray(o[i], result);
                continue;
            }
            result.add(o[i]);
        }
        return result.toArray();
    }

    private static void dumpArray(Object array, List<Object> into) {
        int size = Array.getLength(array);
        for (int j = 0; j < size; ++j) {
            Object found = Array.get(array, j);
            if (found != null && found.getClass().isArray() && found != array) {
                ArrayUtils.dumpArray(found, into);
                continue;
            }
            into.add(found);
        }
    }

    public static long[] toLongArray(int[] ints) {
        long[] result = new long[ints.length];
        for (int i = 0; i < ints.length; ++i) {
            result[i] = ints[i];
        }
        return result;
    }

    public static int[] toIntArray(short[] shorts) {
        int[] result = new int[shorts.length];
        for (int i = 0; i < shorts.length; ++i) {
            result[i] = shorts[i];
        }
        return result;
    }

    public static List<Long> toBoxedList(long[] longs) {
        ArrayList<Long> result = new ArrayList<Long>(longs.length);
        for (long l : longs) {
            result.add(l);
        }
        return result;
    }

    public static List<Integer> toBoxedList(int[] ints) {
        ArrayList<Integer> result = new ArrayList<Integer>(ints.length);
        for (int l : ints) {
            result.add(l);
        }
        return result;
    }

    public static Long[] toBoxedArray(long[] longs) {
        Long[] result = new Long[longs.length];
        for (int i = 0; i < longs.length; ++i) {
            result[i] = longs[i];
        }
        return result;
    }

    public static Integer[] toBoxedArray(int[] ints) {
        Integer[] result = new Integer[ints.length];
        for (int i = 0; i < ints.length; ++i) {
            result[i] = ints[i];
        }
        return result;
    }

    public static long[] toPrimitiveArray(Long[] longs) {
        long[] result = new long[longs.length];
        for (int i = 0; i < longs.length; ++i) {
            assert (longs[i] != null) : "Null in Long array at " + i + Arrays.toString((Object[])longs);
            result[i] = longs[i];
        }
        return result;
    }

    public static int[] toPrimitiveArray(Integer[] ints) {
        int[] result = new int[ints.length];
        for (int i = 0; i < ints.length; ++i) {
            assert (ints[i] != null) : "null in Integer array at " + i + Arrays.toString((Object[])ints);
            result[i] = ints[i];
        }
        return result;
    }

    public static <T extends Number> int[] toIntArray(Collection<T> coll) {
        int[] result = new int[coll.size()];
        Iterator<T> it = coll.iterator();
        for (int i = 0; i < result.length; ++i) {
            result[i] = ((Number)it.next()).intValue();
        }
        return result;
    }

    public static <T extends Number> long[] toLongArray(Collection<T> coll) {
        long[] result = new long[coll.size()];
        Iterator<T> it = coll.iterator();
        for (int i = 0; i < result.length; ++i) {
            result[i] = ((Number)it.next()).longValue();
        }
        return result;
    }

    public static <T> void shuffle(Random rnd, T[] array) {
        for (int i = 0; i < array.length - 2; ++i) {
            int r = rnd.nextInt(array.length);
            if (i == r) continue;
            T hold = array[i];
            array[i] = array[r];
            array[r] = hold;
        }
    }

    public static void shuffle(Random rnd, long[] array) {
        for (int i = 0; i < array.length - 2; ++i) {
            int r = rnd.nextInt(array.length);
            if (i == r) continue;
            long hold = array[i];
            array[i] = array[r];
            array[r] = hold;
        }
    }

    public static void shuffle(Random rnd, double[] array) {
        for (int i = 0; i < array.length - 2; ++i) {
            int r = rnd.nextInt(array.length);
            if (i == r) continue;
            double hold = array[i];
            array[i] = array[r];
            array[r] = hold;
        }
    }

    public static void shuffle(Random rnd, float[] array) {
        for (int i = 0; i < array.length - 2; ++i) {
            int r = rnd.nextInt(array.length);
            if (i == r) continue;
            float hold = array[i];
            array[i] = array[r];
            array[r] = hold;
        }
    }

    public static void shuffle(Random rnd, int[] array) {
        for (int i = 0; i < array.length - 2; ++i) {
            int r = rnd.nextInt(array.length);
            if (i == r) continue;
            int hold = array[i];
            array[i] = array[r];
            array[r] = hold;
        }
    }

    public static void shuffle(Random rnd, char[] array) {
        for (int i = 0; i < array.length - 2; ++i) {
            int r = rnd.nextInt(array.length);
            if (i == r) continue;
            char hold = array[i];
            array[i] = array[r];
            array[r] = hold;
        }
    }

    public static void shuffle(Random rnd, byte[] array) {
        for (int i = 0; i < array.length - 2; ++i) {
            int r = rnd.nextInt(array.length);
            if (i == r) continue;
            byte hold = array[i];
            array[i] = array[r];
            array[r] = hold;
        }
    }

    public static char[] extract(char[] array, int start, int length) {
        Checks.notNull((String)"array", (Object)array);
        Checks.nonNegative((String)"length", (int)length);
        if (start == 0) {
            return Arrays.copyOf(array, length);
        }
        char[] result = new char[length];
        System.arraycopy(array, start, result, 0, length);
        return result;
    }

    public static int[] extract(int[] array, int start, int length) {
        Checks.notNull((String)"array", (Object)array);
        Checks.nonNegative((String)"length", (int)length);
        if (start == 0) {
            return Arrays.copyOf(array, length);
        }
        int[] result = new int[length];
        System.arraycopy(array, start, result, 0, length);
        return result;
    }

    public static long[] extract(long[] array, int start, int length) {
        if (start == 0) {
            return Arrays.copyOf(array, length);
        }
        long[] result = new long[length];
        System.arraycopy(array, start, result, 0, length);
        return result;
    }

    public static byte[] extract(byte[] array, int start, int length) {
        Checks.notNull((String)"array", (Object)array);
        Checks.nonNegative((String)"length", (int)length);
        if (start == 0) {
            return Arrays.copyOf(array, length);
        }
        byte[] result = new byte[length];
        System.arraycopy(array, start, result, 0, length);
        return result;
    }

    public static double[] extract(double[] array, int start, int length) {
        Checks.notNull((String)"array", (Object)array);
        Checks.nonNegative((String)"length", (int)length);
        if (start == 0) {
            return Arrays.copyOf(array, length);
        }
        double[] result = new double[length];
        System.arraycopy(array, start, result, 0, length);
        return result;
    }

    public static float[] extract(float[] array, int start, int length) {
        Checks.notNull((String)"array", (Object)array);
        Checks.nonNegative((String)"length", (int)length);
        if (start == 0) {
            return Arrays.copyOf(array, length);
        }
        float[] result = new float[length];
        System.arraycopy(array, start, result, 0, length);
        return result;
    }

    public static String[] extract(String[] array, int start, int length) {
        Checks.notNull((String)"array", (Object)array);
        Checks.nonNegative((String)"length", (int)length);
        if (start == 0) {
            return Arrays.copyOf(array, length);
        }
        String[] result = new String[length];
        System.arraycopy(array, start, result, 0, length);
        return result;
    }

    public static <T> T[] extract(T[] array, int start, int length) {
        Object[] result;
        Checks.notNull((String)"array", array);
        Checks.nonNegative((String)"length", (int)length);
        if (start == 0) {
            return Arrays.copyOf(array, length);
        }
        if (start + length > array.length) {
            throw new IllegalArgumentException("Extract past end of array - start=" + start + " + len=" + length + " = " + (start + length) + " in array of length " + array.length);
        }
        try {
            result = (Object[])Array.newInstance(array.getClass().getComponentType(), length);
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException("Exception creating array of type " + array.getClass().getComponentType() + " for " + Arrays.toString(array), ex);
        }
        System.arraycopy(array, start, result, 0, length);
        return result;
    }

    public static <T> T[] reversed(T[] array) {
        return ArrayUtils.reverseInPlace(ArrayUtils.copyOf(array));
    }

    public static <T> T[] reverseInPlace(T[] array) {
        if (array.length < 2) {
            return array;
        }
        for (int i = 0; i < array.length / 2; ++i) {
            T hold = array[i];
            array[i] = array[array.length - (i + 1)];
            array[array.length - (i + 1)] = hold;
        }
        return array;
    }

    public static byte[] reversed(byte[] array) {
        return ArrayUtils.reverseInPlace(ArrayUtils.copyOf(array));
    }

    public static byte[] reverseInPlace(byte[] array) {
        if (array.length < 2) {
            return array;
        }
        for (int i = 0; i < array.length / 2; ++i) {
            byte hold = array[i];
            array[i] = array[array.length - (i + 1)];
            array[array.length - (i + 1)] = hold;
        }
        return array;
    }

    public static int[] reversed(int[] array) {
        return ArrayUtils.reverseInPlace(ArrayUtils.copyOf(array));
    }

    public static int[] reverseInPlace(int[] array) {
        if (array.length < 2) {
            return array;
        }
        for (int i = 0; i < array.length / 2; ++i) {
            int hold = array[i];
            array[i] = array[array.length - (i + 1)];
            array[array.length - (i + 1)] = hold;
        }
        return array;
    }

    public static char[] reversed(char[] array) {
        return ArrayUtils.reverseInPlace(ArrayUtils.copyOf(array));
    }

    public static char[] reverseInPlace(char[] array) {
        if (array.length < 2) {
            return array;
        }
        for (int i = 0; i < array.length / 2; ++i) {
            char hold = array[i];
            array[i] = array[array.length - (i + 1)];
            array[array.length - (i + 1)] = hold;
        }
        return array;
    }

    public static double[] reverseInPlace(double[] array) {
        if (array.length < 2) {
            return array;
        }
        for (int i = 0; i < array.length / 2; ++i) {
            double hold = array[i];
            array[i] = array[array.length - (i + 1)];
            array[array.length - (i + 1)] = hold;
        }
        return array;
    }

    public static float[] reverseInPlace(float[] array) {
        if (array.length < 2) {
            return array;
        }
        for (int i = 0; i < array.length / 2; ++i) {
            float hold = array[i];
            array[i] = array[array.length - (i + 1)];
            array[array.length - (i + 1)] = hold;
        }
        return array;
    }

    public static long[] reversed(long[] array) {
        return ArrayUtils.reverseInPlace(ArrayUtils.copyOf(array));
    }

    public static long[] reverseInPlace(long[] array) {
        if (array.length < 2) {
            return array;
        }
        for (int i = 0; i < array.length / 2; ++i) {
            long hold = array[i];
            array[i] = array[array.length - (i + 1)];
            array[array.length - (i + 1)] = hold;
        }
        return array;
    }

    public static <T> T[] copyOf(T[] array) {
        return Arrays.copyOf(array, array.length);
    }

    public static int[] copyOf(int[] array) {
        return Arrays.copyOf(array, array.length);
    }

    public static double[] copyOf(double[] array) {
        return Arrays.copyOf(array, array.length);
    }

    public static float[] copyOf(float[] array) {
        return Arrays.copyOf(array, array.length);
    }

    public static long[] copyOf(long[] array) {
        return Arrays.copyOf(array, array.length);
    }

    public static char[] copyOf(char[] array) {
        return Arrays.copyOf(array, array.length);
    }

    public static byte[] copyOf(byte[] array) {
        return Arrays.copyOf(array, array.length);
    }

    public static Set<Integer> toSet(int[] ints) {
        return new HashSet<Integer>(CollectionUtils.toList(ints));
    }

    public static Set<Long> toSet(long[] ints) {
        return new HashSet<Long>(CollectionUtils.toList(ints));
    }

    public static <T> T[] arrayOf(T obj, int length) {
        Object[] result = (Object[])Array.newInstance(Checks.notNull((String)"obj", obj).getClass(), length);
        Arrays.fill(result, obj);
        return result;
    }

    public static BigInteger[] toBigIntegers(long[] vals) {
        BigInteger[] result = new BigInteger[vals.length];
        for (int i = 0; i < vals.length; ++i) {
            result[i] = BigInteger.valueOf(vals[i]);
        }
        return result;
    }

    public static BigInteger[] toBigIntegers(int[] vals) {
        BigInteger[] result = new BigInteger[vals.length];
        for (int i = 0; i < vals.length; ++i) {
            result[i] = BigInteger.valueOf(vals[i]);
        }
        return result;
    }

    public static boolean timingSafeEquals(byte[] first, byte[] second) {
        if (first == null) {
            return second == null;
        }
        if (second == null) {
            return false;
        }
        if (second.length <= 0) {
            return first.length <= 0;
        }
        byte result = (byte)(first.length != second.length ? 1 : 0);
        int j = 0;
        for (int i = 0; i < first.length; ++i) {
            result = (byte)(result | first[i] ^ second[j]);
            j = (j + 1) % second.length;
        }
        return result == 0;
    }

    public static boolean arraysEquals(int[] a, int aFromIndex, int aToIndex, int[] b, int bFromIndex, int bToIndex) {
        int aLength = aToIndex - aFromIndex;
        int bLength = bToIndex - bFromIndex;
        if (aLength != bLength) {
            return false;
        }
        while (aFromIndex < aToIndex && bFromIndex < bToIndex) {
            if (a[aFromIndex] != b[bFromIndex]) {
                return false;
            }
            ++aFromIndex;
            ++bFromIndex;
        }
        return true;
    }

    public static String[] prepend(String first, String ... more) {
        String[] result = new String[more.length + 1];
        System.arraycopy(more, 0, result, 1, more.length);
        result[0] = first;
        return result;
    }

    public static int[] prepend(int first, int ... more) {
        int[] result = new int[more.length + 1];
        System.arraycopy(more, 0, result, 1, more.length);
        result[0] = first;
        return result;
    }

    public static char[] prepend(char first, char ... more) {
        char[] result = new char[more.length + 1];
        System.arraycopy(more, 0, result, 1, more.length);
        result[0] = first;
        return result;
    }

    @SafeVarargs
    public static <T> T[] prepend(T first, T ... more) {
        Checks.notNull((String)"more", more);
        Checks.isInstance((String)"first", more.getClass().getComponentType(), first);
        if (more.length == 0) {
            ?[] result = CollectionUtils.genericArray(more.getClass().getComponentType(), 1);
            result[0] = first;
            return result;
        }
        ?[] result = CollectionUtils.genericArray(more.getClass().getComponentType(), more.length + 1);
        System.arraycopy(more, 0, result, 1, more.length);
        result[0] = first;
        return result;
    }

    public static long[] prepend(long first, long ... more) {
        long[] result = new long[more.length + 1];
        System.arraycopy(more, 0, result, 1, more.length);
        result[0] = first;
        return result;
    }

    public static short[] prepend(short first, short ... more) {
        short[] result = new short[more.length + 1];
        System.arraycopy(more, 0, result, 1, more.length);
        result[0] = first;
        return result;
    }

    public static byte[] prepend(byte first, byte ... more) {
        byte[] result = new byte[more.length + 1];
        System.arraycopy(more, 0, result, 1, more.length);
        result[0] = first;
        return result;
    }

    public static double[] prepend(double first, double ... more) {
        double[] result = new double[more.length + 1];
        System.arraycopy(more, 0, result, 1, more.length);
        result[0] = first;
        return result;
    }

    public static float[] prepend(float first, float ... more) {
        float[] result = new float[more.length + 1];
        System.arraycopy(more, 0, result, 1, more.length);
        result[0] = first;
        return result;
    }

    public static float[] append(float last, float ... to) {
        float[] result = Arrays.copyOf(to, to.length + 1);
        result[result.length - 1] = last;
        return result;
    }

    public static double[] append(double last, double ... to) {
        double[] result = Arrays.copyOf(to, to.length + 1);
        result[result.length - 1] = last;
        return result;
    }

    public static int[] append(int last, int ... to) {
        int[] result = Arrays.copyOf(to, to.length + 1);
        result[result.length - 1] = last;
        return result;
    }

    public static long[] append(long last, long ... to) {
        long[] result = Arrays.copyOf(to, to.length + 1);
        result[result.length - 1] = last;
        return result;
    }

    public static short[] append(short last, short ... to) {
        short[] result = Arrays.copyOf(to, to.length + 1);
        result[result.length - 1] = last;
        return result;
    }

    public static byte[] append(byte last, byte ... to) {
        byte[] result = Arrays.copyOf(to, to.length + 1);
        result[result.length - 1] = last;
        return result;
    }

    public static void apply(double[] dbls, DoubleUnaryOperator op) {
        for (int i = 0; i < dbls.length; ++i) {
            dbls[i] = op.applyAsDouble(dbls[i]);
        }
    }

    public static void apply(float[] floats, DoubleUnaryOperator op) {
        for (int i = 0; i < floats.length; ++i) {
            floats[i] = (float)op.applyAsDouble(floats[i]);
        }
    }

    public static float[] copyAndApply(float[] floats, DoubleUnaryOperator op) {
        floats = ArrayUtils.copyOf(floats);
        ArrayUtils.apply(floats, op);
        return floats;
    }

    public static double[] copyAndApply(double[] dbls, DoubleUnaryOperator op) {
        dbls = ArrayUtils.copyOf(dbls);
        ArrayUtils.apply(dbls, op);
        return dbls;
    }

    public static double[] toDoubleArray(float[] arr) {
        double[] result = new double[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            result[i] = arr[i];
        }
        return result;
    }

    public static double[] toDoubleArray(int[] ints) {
        double[] result = new double[ints.length];
        for (int i = 0; i < ints.length; ++i) {
            result[i] = ints[i];
        }
        return result;
    }

    public static float[] toFloatArray(int[] ints) {
        float[] result = new float[ints.length];
        for (int i = 0; i < ints.length; ++i) {
            result[i] = ints[i];
        }
        return result;
    }

    public static float[] toFloatArray(double[] dbls, DoubleUnaryOperator outOfRange) {
        float[] result = new float[dbls.length];
        for (int i = 0; i < dbls.length; ++i) {
            double val = dbls[i];
            if (val < (double)1.4E-45f || val > 3.4028234663852886E38) {
                val = outOfRange.applyAsDouble(val);
            }
            result[i] = (float)val;
        }
        return result;
    }
}

