/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.util.collections;

import com.mastfrog.util.collections.ArrayUtils;
import com.mastfrog.util.collections.ArraysPool;
import com.mastfrog.util.preconditions.Checks;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;

abstract class ArraysManager<T>
implements Iterable<T> {
    final LinkedList<T> arrays = new LinkedList();
    final ArraysPool<T> pool;
    final int batchSize;
    static boolean blank = Boolean.getBoolean("unit.test");

    ArraysManager(int batchSize, ArraysPool<T> pool) {
        this.batchSize = Checks.greaterThanOne((String)"batchSize", (int)batchSize);
        this.pool = pool;
    }

    ArraysManager(ArraysManager<T> other, ArraysPool<T> pool) {
        this.batchSize = other.batchSize();
        for (Object t : other.arrays) {
            this.arrays.add(other.duplicate(t));
        }
        this.pool = pool;
    }

    int batchSize() {
        return this.batchSize;
    }

    @Override
    public Iterator<T> iterator() {
        return this.arrays.iterator();
    }

    void clear() {
        for (Object arr : this.arrays) {
            this.pool.dispose(arr);
        }
        this.arrays.clear();
    }

    void pruneTo(int size) {
        int targetSize = size / this.batchSize + 1;
        int sz = this.arrays.size();
        while (sz > targetSize + 1 && sz > 0) {
            T arr = this.arrays.remove(sz - 1);
            this.pool.dispose(arr);
            sz = this.arrays.size();
        }
    }

    boolean isEmpty() {
        return this.arrays.isEmpty();
    }

    T get(int index) {
        return this.arrays.get(index);
    }

    int size() {
        return this.arrays.size();
    }

    int capacity() {
        return this.arrays.size() * this.batchSize;
    }

    void remove(int index) {
        this.pool.dispose(this.arrays.remove(index));
    }

    T addOne() {
        T nue = this.newArray();
        this.arrays.add(nue);
        return nue;
    }

    T addOne(int index) {
        T nue = this.newArray();
        this.arrays.add(index, nue);
        return nue;
    }

    void ensureIndexAvailable(int index) {
        this.ensureCapacity(index + 1);
    }

    void ensureCapacity(int capacity) {
        while (capacity < this.capacity()) {
            this.addOne();
        }
    }

    void removeRange(int fromIndex, int toIndex) {
        if (fromIndex != toIndex) {
            int count;
            int offsetIntoAffectedArray = fromIndex % this.batchSize;
            int firstAffectedArray = fromIndex / this.batchSize;
            if (count == this.batchSize && offsetIntoAffectedArray == 0) {
                this.pool.dispose(this.arrays.remove(firstAffectedArray));
                return;
            }
            for (count = toIndex - fromIndex; count > this.batchSize + (this.batchSize - offsetIntoAffectedArray); count -= this.batchSize) {
                this.pool.dispose(this.arrays.remove(firstAffectedArray + 1));
            }
            if (count > 0 && count <= this.batchSize) {
                this.shiftOneArrayLeft(firstAffectedArray, offsetIntoAffectedArray, count);
            } else {
                T old = this.get(firstAffectedArray);
                this.pool.dispose(this.arrays.remove(firstAffectedArray));
                int ct = count - this.batchSize;
                this.shiftOneArrayLeft(firstAffectedArray, offsetIntoAffectedArray, ct);
                if (offsetIntoAffectedArray > 0) {
                    this.copy(old, 0, this.get(firstAffectedArray), 0, offsetIntoAffectedArray);
                }
            }
        }
    }

    void shiftOneArrayLeft(int arrIndex, int start, int by) {
        assert (by <= this.batchSize) : "Cannot shift by " + by + " is > batch size " + this.batchSize;
        T curr = this.arrays.get(arrIndex);
        int endOffset = start + by;
        int length = this.batchSize - endOffset;
        if (endOffset < this.batchSize) {
            this.copy(curr, endOffset, curr, start, length);
        }
        if (arrIndex != this.arrays.size() - 1) {
            T next = this.arrays.get(arrIndex + 1);
            if (endOffset < this.batchSize) {
                this.copy(next, 0, curr, this.batchSize - by, by);
                this.shiftOneArrayLeft(arrIndex + 1, 0, by);
            } else {
                int copyFrom = by - (this.batchSize - start);
                int amt = this.batchSize - start;
                this.copy(next, copyFrom, curr, start, amt);
                this.shiftOneArrayLeft(arrIndex + 1, 0, by);
            }
        }
    }

    void blank(T arr, int from, int to) {
        if (blank) {
            this.doBlank(arr, from, to);
        }
    }

    abstract void doBlank(T var1, int var2, int var3);

    T shiftOneArrayRightFromZero(int arrIndex, int by, boolean shiftPreceding, boolean expand) {
        return this.shiftOneArrayRightFromZero(arrIndex, by, shiftPreceding, expand, false);
    }

    void removeAt(int index) {
        int arrayIndex = index / this.batchSize;
        if (arrayIndex >= this.arrays.size()) {
            throw new IndexOutOfBoundsException("Array index " + arrayIndex + " > " + this.arrays.size() + " for index " + index + " with arrays.batchSize() " + this.batchSize);
        }
        this.shiftOneArrayLeft(arrayIndex, index % this.batchSize, 1);
    }

    T shiftOneArrayRightFromZero(int arrIndex, int by, boolean shiftPreceding, boolean expand, boolean neverExpand) {
        boolean last;
        if (arrIndex > this.size()) {
            throw new IllegalArgumentException("arrayIndex > size");
        }
        if (neverExpand) {
            expand = false;
        }
        assert (by != 0) : "Shift by 0 of " + arrIndex;
        if (by >= this.batchSize && by % this.batchSize == 0) {
            int toAdd = by / this.batchSize;
            Object result = null;
            Object realResult = null;
            for (int i = 0; i < toAdd; ++i) {
                result = this.newArray();
                if (realResult == null) {
                    realResult = result;
                }
                this.blank(result, 0, this.batchSize);
                this.arrays.add(arrIndex, result);
            }
            return (T)realResult;
        }
        if (by > this.batchSize) {
            int toAdd = by / this.batchSize;
            this.shiftOneArrayRightFromZero(arrIndex, by % this.batchSize, shiftPreceding, expand, neverExpand);
            for (int i = 0; i < toAdd; ++i) {
                T result = this.newArray();
                this.blank(result, 0, this.batchSize);
                this.arrays.add(arrIndex, result);
            }
            return this.get(arrIndex);
        }
        boolean bl = last = arrIndex >= this.size() - 1;
        if (expand && last) {
            this.addOne();
            this.shiftOneArrayRightFromZero(arrIndex + 1, by, true, false, true);
        } else if (!last) {
            this.shiftOneArrayRightFromZero(arrIndex + 1, by, true, expand, neverExpand);
        }
        if (arrIndex >= this.size()) {
            return null;
        }
        T curr = this.get(arrIndex);
        int tailLength = this.batchSize - by;
        if (tailLength > 0) {
            this.copy(curr, 0, curr, by, tailLength);
            this.blank(curr, 0, by % this.batchSize);
        }
        if (shiftPreceding && arrIndex > 0) {
            T prev = this.get(arrIndex - 1);
            this.copy(prev, this.batchSize - by, curr, 0, by);
        } else if (!shiftPreceding) {
            this.blank(curr, 0, by);
        }
        return curr;
    }

    abstract boolean isSorted(T var1);

    abstract boolean isSorted(T var1, int var2);

    T shiftOneArrayRight(int arrIndex, int start, int by) {
        if (start > this.batchSize) {
            arrIndex += start / this.batchSize;
            start -= this.batchSize * (start / this.batchSize);
        }
        if (by > this.batchSize) {
            if (start == 0) {
                return this.shiftOneArrayRightFromZero(arrIndex, by, false, true, false);
            }
            T arr = this.get(arrIndex);
            int shiftForSubsequentArrays = by - (this.batchSize - start);
            if (shiftForSubsequentArrays < this.batchSize) {
                T targetArray = this.shiftOneArrayRightFromZero(arrIndex + 1, by, true, true, false);
                int endOffset = (start + by) % this.batchSize;
                int len = this.batchSize - endOffset;
                this.copy(arr, start, targetArray, endOffset, len);
                this.blank(arr, start, this.batchSize);
                return targetArray;
            }
            T targetArray = this.shiftOneArrayRightFromZero(arrIndex + 1, by, true, true, false);
            int endOffset = (start + by) % this.batchSize;
            int len = this.batchSize - start;
            int targetArrayIndex = arrIndex + shiftForSubsequentArrays / this.batchSize + 1;
            targetArray = this.get(targetArrayIndex);
            if (len > 0) {
                int copyStart = start;
                if (len + endOffset > this.batchSize) {
                    len = this.batchSize - endOffset;
                }
                this.copy(arr, copyStart, targetArray, endOffset, len);
            }
            this.blank(targetArray, 0, endOffset);
            this.blank(arr, start, this.batchSize);
            return targetArray;
        }
        assert (start <= this.batchSize) : "Start point > batch size: " + start + " arrIndex " + arrIndex + " by " + by;
        assert (by <= this.batchSize) : "Cannot shift by " + by + " is > batch size " + this.batchSize;
        assert (by > 0) : "Cannot shift by zero - meaningless argument.  ArrIndex " + arrIndex + " start " + start + " by " + by;
        if (start != 0 && start % this.batchSize == 0 && arrIndex > 0) {
            --arrIndex;
        }
        T curr = this.get(arrIndex);
        int end = start + by + 1;
        if (start % this.batchSize == 0) {
            curr = this.shiftOneArrayRightFromZero(arrIndex, by, false, true, false);
        } else if (end == this.batchSize) {
            if (end > this.capacity() - this.batchSize * arrIndex) {
                this.addOne();
            }
            this.shiftOneArrayRightFromZero(arrIndex + 1, by, false, true, false);
            if (arrIndex != this.size() - 1) {
                T next = this.get(arrIndex + 1);
                int copyStart = start + (this.batchSize - (end - 1));
                int copyLen = this.batchSize - copyStart;
                this.copy(curr, copyStart, next, 0, copyLen);
            }
            this.copy(curr, start, curr, start + by, this.batchSize - (start + by));
        } else if (end > this.batchSize) {
            int nextOff = end - this.batchSize * (arrIndex - 1) - 1;
            if (nextOff < 0) {
                nextOff = end - this.batchSize * (arrIndex - 2) - 1;
            }
            this.shiftOneArrayRightFromZero(arrIndex + 1, by, false, true);
            if (arrIndex != this.size() - 1) {
                T next = this.get(arrIndex + 1);
                int copyStart = start;
                int copyLen = this.batchSize - copyStart;
                int dest = nextOff % this.batchSize;
                assert (dest >= 0) : "Negative destination " + nextOff + " " + nextOff + " end " + end + " batchSize " + this.batchSize + " shifting array " + arrIndex + " of " + this.size() + " by " + by + " boundary " + this.batchSize * (arrIndex - 1);
                if (copyLen > 0) {
                    this.copy(curr, copyStart, next, nextOff % this.batchSize, copyLen);
                } else if (copyLen < 0) {
                    throw new IllegalStateException("Huh? " + copyStart + " - length " + copyLen);
                }
            }
        } else {
            if (arrIndex != this.arrays.size() - 1) {
                this.shiftOneArrayRightFromZero(arrIndex + 1, by, false, true);
            } else {
                this.addOne();
                this.shiftOneArrayRightFromZero(arrIndex + 1, by, false, false, true);
            }
            if (arrIndex != this.size() - 1) {
                T next = this.get(arrIndex + 1);
                int copyStart = this.batchSize - by;
                int copyLen = by;
                this.copy(curr, copyStart, next, 0, copyLen);
            }
            this.copy(curr, start, curr, end - 1, this.batchSize - (end - 1));
        }
        int toBlank = start + by >= this.batchSize ? this.batchSize - start : by;
        this.blank(curr, start, start + toBlank);
        return curr;
    }

    void copy(T src, int srcPos, T dest, int destPos, int count) {
        System.arraycopy(src, srcPos, dest, destPos, count);
    }

    final T newArray() {
        return this.pool.get();
    }

    abstract T duplicate(T var1);

    static final class Bytes
    extends ArraysManager<byte[]> {
        public Bytes(int batchSize, ArraysPool<byte[]> pool) {
            super(batchSize, pool);
        }

        public Bytes(ArraysManager<byte[]> other, ArraysPool<byte[]> pool) {
            super(other, pool);
        }

        public Bytes(int batchSize, SortChecker checker, byte[][] contents, ArraysPool<byte[]> pool) {
            super(batchSize, pool);
            byte[] curr = (byte[])this.newArray();
            this.arrays.add(curr);
            int cursor = 0;
            long prev = Long.MIN_VALUE;
            int ix = 0;
            boolean sorted = true;
            for (byte[] arr : contents) {
                for (int i = 0; i < arr.length; ++i) {
                    if (cursor == curr.length) {
                        curr = (byte[])this.newArray();
                        this.arrays.add(curr);
                        cursor = 0;
                    }
                    byte val = arr[i];
                    curr[cursor++] = val;
                    if (ix > 0) {
                        sorted &= prev < (long)val;
                    }
                    ++ix;
                    prev = val;
                }
            }
            if (checker != null) {
                checker.sorted(sorted);
            }
        }

        @Override
        byte[] duplicate(byte[] val) {
            return Arrays.copyOf(val, val.length);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.size()).append(" arrays batchSize ").append(this.batchSize).append(":\n[");
            int len = this.arrays.size();
            for (int i = 0; i < len; ++i) {
                byte[] l = (byte[])this.arrays.get(i);
                for (int j = 0; j < l.length; ++j) {
                    String s = Long.toString(l[j]);
                    if (i != 0 && j != 0) {
                        sb.append(' ');
                    }
                    if (s.length() == 1) {
                        sb.append(' ');
                    }
                    sb.append(s);
                }
                if (i == len - 1) continue;
                sb.append(" |");
            }
            return sb.append(']').toString();
        }

        @Override
        void copy(byte[] src, int srcPos, byte[] dest, int destPos, int count) {
            if (count == 0) {
                String intra = src == dest ? "intra-" : "extra-";
                throw new IllegalArgumentException("Silly argument - " + intra + "copy 0 bytes from " + srcPos + " to " + destPos + " in array of " + src.length);
            }
            try {
                super.copy(src, srcPos, dest, destPos, count);
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                String intra = src == dest ? "intra-" : "extra-";
                throw new IllegalArgumentException(intra + "copy " + count + " entries from " + srcPos + " to " + destPos + " in arr of " + dest.length + " destPos " + destPos + " count " + count + " - srcEnd = " + (srcPos + count) + ", destEnd = " + (destPos + count), ex);
            }
        }

        @Override
        void doBlank(byte[] arr, int from, int to) {
            Arrays.fill(arr, from, to, (byte)-1);
        }

        byte[] toByteArray() {
            return this.toByteArray(this.capacity());
        }

        byte[] toByteArray(int size) {
            if (this.arrays.isEmpty()) {
                return new byte[0];
            }
            if (this.arrays.size() == 1) {
                byte[] arr = (byte[])this.arrays.get(0);
                return Arrays.copyOf(arr, size);
            }
            byte[] a = (byte[])this.arrays.get(0);
            byte[] b = (byte[])this.arrays.get(1);
            if (this.arrays.size() == 2) {
                byte[] result = ArrayUtils.concatenate(a, b);
                if (result.length > size) {
                    return Arrays.copyOf(result, size);
                }
                return result;
            }
            byte[][] remaining = new byte[this.arrays.size() - 2][];
            for (int i = 2; i < this.arrays.size(); ++i) {
                remaining[i - 2] = (byte[])this.arrays.get(i);
            }
            byte[] result = ArrayUtils.concatenate(a, b, remaining);
            if (result.length > size) {
                result = Arrays.copyOf(result, size);
            }
            return result;
        }

        @Override
        boolean isSorted(byte[] t) {
            return this.isSorted(t, t.length);
        }

        @Override
        boolean isSorted(byte[] t, int size) {
            if (size <= 1) {
                return true;
            }
            if (size == 2) {
                return t[1] > t[0];
            }
            long prevLast = -128L;
            long prevFirst = 0L;
            int max = size % 2 == 0 ? size / 2 : size / 2 + 1;
            for (int i = 0; i < max; ++i) {
                int lo = size - 1 - i;
                if (lo <= i) {
                    return true;
                }
                byte last = t[lo];
                byte first = t[i];
                if (last <= first) {
                    return false;
                }
                if (lo < max && prevLast >= (long)last) {
                    return false;
                }
                if (i > 0 && prevFirst >= (long)first) {
                    return false;
                }
                prevLast = last;
                prevFirst = first;
            }
            return true;
        }
    }

    static final class Longs
    extends ArraysManager<long[]> {
        public Longs(int batchSize, ArraysPool<long[]> pool) {
            super(batchSize, pool);
        }

        public Longs(int batchSize) {
            super(batchSize, ArraysPool.cachingPool(batchSize, 3, 7));
        }

        public Longs(ArraysManager<long[]> other) {
            super(other, other.pool);
        }

        public Longs(int batchSize, SortChecker checker, long[][] contents) {
            this(batchSize, checker, contents, ArraysPool.cachingPool(batchSize, 3, 7));
        }

        public Longs(int batchSize, SortChecker checker, long[][] contents, ArraysPool<long[]> pool) {
            super(batchSize, pool);
            long[] curr = (long[])this.newArray();
            this.arrays.add(curr);
            int cursor = 0;
            long prev = Long.MIN_VALUE;
            int ix = 0;
            boolean sorted = true;
            for (long[] arr : contents) {
                for (int i = 0; i < arr.length; ++i) {
                    if (cursor == curr.length) {
                        curr = (long[])this.newArray();
                        this.arrays.add(curr);
                        cursor = 0;
                    }
                    long val = arr[i];
                    curr[cursor++] = val;
                    if (ix > 0) {
                        sorted &= prev < val;
                    }
                    ++ix;
                    prev = val;
                }
            }
            if (checker != null) {
                checker.sorted(sorted);
            }
        }

        @Override
        long[] duplicate(long[] val) {
            return Arrays.copyOf(val, val.length);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.size()).append(" arrays batchSize ").append(this.batchSize).append(":\n[");
            int len = this.arrays.size();
            for (int i = 0; i < len; ++i) {
                long[] l = (long[])this.arrays.get(i);
                for (int j = 0; j < l.length; ++j) {
                    String s = Long.toString(l[j]);
                    if (i != 0 && j != 0) {
                        sb.append(' ');
                    }
                    if (s.length() == 1) {
                        sb.append(' ');
                    }
                    sb.append(s);
                }
                if (i == len - 1) continue;
                sb.append(" |");
            }
            return sb.append(']').toString();
        }

        @Override
        void copy(long[] src, int srcPos, long[] dest, int destPos, int count) {
            if (count == 0) {
                String intra = src == dest ? "intra-" : "extra-";
                throw new IllegalArgumentException("Silly argument - " + intra + "copy 0 bytes from " + srcPos + " to " + destPos + " in array of " + src.length);
            }
            try {
                super.copy(src, srcPos, dest, destPos, count);
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                String intra = src == dest ? "intra-" : "extra-";
                throw new IllegalArgumentException(intra + "copy " + count + " entries from " + srcPos + " to " + destPos + " in arr of " + dest.length + " destPos " + destPos + " count " + count + " - srcEnd = " + (srcPos + count) + ", destEnd = " + (destPos + count), ex);
            }
        }

        @Override
        void doBlank(long[] arr, int from, int to) {
            Arrays.fill(arr, from, to, -1L);
        }

        long[] toLongArray() {
            return this.toLongArray(this.capacity());
        }

        long[] toLongArray(int size) {
            if (this.arrays.isEmpty()) {
                return new long[0];
            }
            if (this.arrays.size() == 1) {
                long[] arr = (long[])this.arrays.get(0);
                return Arrays.copyOf(arr, size);
            }
            long[] a = (long[])this.arrays.get(0);
            long[] b = (long[])this.arrays.get(1);
            if (this.arrays.size() == 2) {
                long[] result = ArrayUtils.concatenate(a, b);
                if (result.length > size) {
                    return Arrays.copyOf(result, size);
                }
                return result;
            }
            long[][] remaining = new long[this.arrays.size() - 2][];
            for (int i = 2; i < this.arrays.size(); ++i) {
                remaining[i - 2] = (long[])this.arrays.get(i);
            }
            long[] result = ArrayUtils.concatenate(a, b, remaining);
            if (result.length > size) {
                result = Arrays.copyOf(result, size);
            }
            return result;
        }

        @Override
        boolean isSorted(long[] t) {
            return this.isSorted(t, t.length);
        }

        @Override
        boolean isSorted(long[] t, int size) {
            if (size <= 1) {
                return true;
            }
            if (size == 2) {
                return t[1] > t[0];
            }
            long prevLast = Long.MIN_VALUE;
            long prevFirst = 0L;
            int max = size % 2 == 0 ? size / 2 : size / 2 + 1;
            for (int i = 0; i < max; ++i) {
                int lo = size - 1 - i;
                if (lo <= i) {
                    return true;
                }
                long last = t[lo];
                long first = t[i];
                if (last <= first) {
                    return false;
                }
                if (lo < max && prevLast >= last) {
                    return false;
                }
                if (i > 0 && prevFirst >= first) {
                    return false;
                }
                prevLast = last;
                prevFirst = first;
            }
            return true;
        }
    }

    static interface SortChecker {
        public void sorted(boolean var1);
    }
}

