/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.util.collections;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.function.Supplier;

abstract class ArraysPool<T>
implements Supplier<T> {
    ArraysPool() {
    }

    @Override
    public abstract T get();

    public abstract void dispose(T var1);

    public static ArraysPool<long[]> cachingPool(int arrayLength, int initialArrays, int maxArrays) {
        return new CachingPool<long[]>(initialArrays, maxArrays, new LongArraySupplier(arrayLength));
    }

    public static ArraysPool<long[]> uncachedPool(int arrayLength) {
        return new LongArraySupplier(arrayLength);
    }

    static final class CachingPool<T>
    extends ArraysPool<T> {
        private final Set<T> active = new HashSet<T>();
        private final LinkedList<T> inactive = new LinkedList();
        private final int max;
        private final Supplier<T> supplier;

        CachingPool(int initial, int max, Supplier<T> supp) {
            this.max = max;
            this.supplier = supp;
            for (int i = 0; i < initial; ++i) {
                this.inactive.add(supp.get());
            }
        }

        @Override
        public synchronized T get() {
            T result;
            int inactiveSize = this.inactive.size();
            int count = this.active.size() + inactiveSize;
            if (inactiveSize > 0) {
                result = this.inactive.pop();
                this.active.add(result);
            } else {
                result = this.supplier.get();
                if (count < this.max) {
                    this.active.add(result);
                }
            }
            return result;
        }

        @Override
        public synchronized void dispose(T arr) {
            this.active.remove(arr);
            int inactiveSize = this.inactive.size();
            int count = this.active.size() + inactiveSize;
            if (count < this.max) {
                this.inactive.push(arr);
            }
        }
    }

    static final class LongArraySupplier
    extends ArraysPool<long[]>
    implements Supplier<long[]> {
        private final int length;

        public LongArraySupplier(int length) {
            this.length = length;
        }

        @Override
        public long[] get() {
            return new long[this.length];
        }

        @Override
        public void dispose(long[] arr) {
        }
    }
}

