/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.util.collections;

import com.mastfrog.util.collections.Converter;
import com.mastfrog.util.strings.Strings;
import java.util.stream.IntStream;

final class CharSequenceKey<T extends CharSequence>
implements CharSequence {
    private final T value;

    private CharSequenceKey(T value) {
        this.value = value;
    }

    public static <T extends CharSequence> CharSequenceKey<T> create(CharSequence seq) {
        return seq instanceof CharSequenceKey ? (CharSequenceKey<Object>)seq : new CharSequenceKey<CharSequence>(seq);
    }

    static <T extends CharSequence> Converter<CharSequenceKey<T>, T> converter() {
        return new Conv();
    }

    T get() {
        return this.value;
    }

    @Override
    public int length() {
        return this.value.length();
    }

    @Override
    public char charAt(int index) {
        return this.value.charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return new CharSequenceKey<CharSequence>(this.value.subSequence(start, end));
    }

    @Override
    public IntStream chars() {
        return this.value.chars();
    }

    @Override
    public IntStream codePoints() {
        return this.value.codePoints();
    }

    public int hashCode() {
        return Strings.charSequenceHashCode(this.value, (boolean)true);
    }

    public boolean equals(Object o) {
        return o instanceof CharSequence && Strings.charSequencesEqual(this.value, (CharSequence)((CharSequence)o), (boolean)true);
    }

    @Override
    public String toString() {
        return this.value.toString();
    }

    /* synthetic */ CharSequenceKey(CharSequence x0, 1 x1) {
        this(x0);
    }

    static class Conv<T extends CharSequence>
    implements Converter<CharSequenceKey<T>, T> {
        Conv() {
        }

        @Override
        public CharSequenceKey<T> convert(T r) {
            return new CharSequenceKey((CharSequence)r, null);
        }

        @Override
        public T unconvert(CharSequenceKey<T> t) {
            return (T)((CharSequenceKey)t).value;
        }
    }
}

