/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.util.collections;

import com.mastfrog.abstractions.list.LongResolvable;
import com.mastfrog.util.collections.ArrayBinarySet;
import com.mastfrog.util.collections.ArrayBinarySetMutable;
import com.mastfrog.util.collections.ArrayIntMap;
import com.mastfrog.util.collections.ArraySet;
import com.mastfrog.util.collections.ArrayUtils;
import com.mastfrog.util.collections.BlackHole;
import com.mastfrog.util.collections.CharSequenceKey;
import com.mastfrog.util.collections.ConcatenatedIterables;
import com.mastfrog.util.collections.ConvertIterator;
import com.mastfrog.util.collections.ConvertList;
import com.mastfrog.util.collections.ConvertedMap;
import com.mastfrog.util.collections.ConvertedReadOnlyList;
import com.mastfrog.util.collections.Converter;
import com.mastfrog.util.collections.EnumerationAdapter;
import com.mastfrog.util.collections.IdentityList;
import com.mastfrog.util.collections.ImmutableArrayMap;
import com.mastfrog.util.collections.IntMap;
import com.mastfrog.util.collections.IntSet;
import com.mastfrog.util.collections.Interator;
import com.mastfrog.util.collections.LongList;
import com.mastfrog.util.collections.LongListImpl;
import com.mastfrog.util.collections.Longerator;
import com.mastfrog.util.collections.MapBuilder2;
import com.mastfrog.util.collections.MapBuilder2Impl;
import com.mastfrog.util.collections.MergeIterables;
import com.mastfrog.util.collections.MergeListIterator;
import com.mastfrog.util.collections.MultiList;
import com.mastfrog.util.collections.ReverseConverter;
import com.mastfrog.util.collections.ReversedList;
import com.mastfrog.util.collections.SimpleWeakSet;
import com.mastfrog.util.collections.SingleItemList;
import com.mastfrog.util.collections.SupplierMap;
import com.mastfrog.util.collections.UnknownTypeArrayList;
import com.mastfrog.util.collections.UnmodifiableIterator;
import com.mastfrog.util.collections.WrapAsListIterator;
import com.mastfrog.util.preconditions.Checks;
import com.mastfrog.util.strings.Strings;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

public final class CollectionUtils {
    private CollectionUtils() {
        throw new AssertionError();
    }

    public static <T> Set<T> weakSet() {
        return new SimpleWeakSet();
    }

    public static <T> Set<T> blackHoleSet() {
        return BlackHole.SET;
    }

    public static <T> List<T> blackHoleList() {
        return BlackHole.LIST;
    }

    public static <T> ConcatenatedIterables<T> concatenate(Iterable<Iterable<T>> iterables) {
        return new MergeIterables<T>(iterables);
    }

    public static <T> ConcatenatedIterables<T> concatenate(Iterable<T> a, Iterable<T> b) {
        return new MergeIterables<T>(a, b);
    }

    public static <T> ConcatenatedIterables<T> concatenate(Iterable<T> a, Iterable<T> b, Iterable<T> c) {
        return new MergeIterables<T>(a, b, c);
    }

    @SafeVarargs
    public static <T> ConcatenatedIterables<T> concatenate(Iterable<T> ... iterables) {
        return new MergeIterables<T>(iterables);
    }

    public static <T> List<T> filter(List<? extends T> list, Predicate<? super T> filter) {
        ArrayList result = new ArrayList(list.size());
        list.stream().filter(obj -> filter.test(obj)).forEachOrdered(result::add);
        return result;
    }

    static void checkDuplicates(Collection<?> collection) {
        boolean asserts = false;
        if (!$assertionsDisabled) {
            asserts = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (asserts) {
            HashSet objs = new HashSet(collection);
            assert (objs.size() == collection.size()) : "Collection may not contain duplicates: " + collection;
        }
    }

    public static LongList longList(int batchSize) {
        return new LongListImpl(batchSize);
    }

    public static LongList longList(long ... longs) {
        return new LongListImpl(longs);
    }

    public static LongList longList(int batchSize, long[] longs) {
        return new LongListImpl(longs, batchSize);
    }

    public static LongList longList(int batchSize, Collection<? extends Long> c) {
        return new LongListImpl(ArrayUtils.toLongArray(c), batchSize);
    }

    public static LongList longList() {
        return new LongListImpl();
    }

    @SafeVarargs
    static <T extends Comparable<T>> Set<T> mutableArraySet(T first, T ... more) {
        for (T m : more) {
            if (first.getClass() == m.getClass()) continue;
            throw new IllegalArgumentException("All elements must be of the same exact type to create without passing a class object, but saw both " + first.getClass().getName() + " and " + m.getClass().getName());
        }
        Class<?> type = first.getClass();
        Comparable[] arr = (Comparable[])Array.newInstance(type, more.length + 1);
        arr[0] = first;
        System.arraycopy(more, 0, arr, 1, more.length);
        return new ArrayBinarySetMutable<Comparable>(true, true, new ComparableComparator(), arr);
    }

    static <T extends Comparable<T>> Set<T> mutableArraySet(Class<T> type) {
        return CollectionUtils.mutableArraySet(type, 16);
    }

    static <T extends Comparable<T>> Set<T> mutableArraySet(Class<T> type, int initialCapacity) {
        ComparableComparator cc = new ComparableComparator();
        return new ArrayBinarySetMutable(true, cc, initialCapacity, type);
    }

    static <T> Set<T> mutableArraySet(Class<T> type, Comparator<T> comp) {
        return CollectionUtils.mutableArraySet(type, comp, 16);
    }

    static <T> Set<T> mutableArraySet(Class<T> type, Comparator<T> comp, int initialCapacity) {
        return new ArrayBinarySetMutable<T>(true, comp, initialCapacity, type);
    }

    public static <T> Iterator<T> unmodifiableIterator(Iterator<T> iter) {
        return iter instanceof UnmodifiableIterator ? iter : new UnmodifiableIterator(iter);
    }

    public static <T, R> Map<T, R> checkedMapByFilter(Map<?, ?> map, Class<T> t, Class<R> r) {
        Checks.notNull((String)"map", map);
        TreeMap<T, R> result = map instanceof SortedMap ? new TreeMap<T, R>() : (map instanceof LinkedHashMap ? new LinkedHashMap() : new HashMap());
        for (Map.Entry<?, ?> e : map.entrySet()) {
            if (!t.isInstance(e.getKey()) || !r.isInstance(e.getValue())) continue;
            result.put(t.cast(e.getKey()), r.cast(e.getValue()));
        }
        return result;
    }

    public static <T, R> Map<T, R> uncheckedMap(Map<?, ?> map) {
        return map;
    }

    public static <T, R> Map<T, R> checkedMap(Map<?, ?> map, Class<T> t, Class<R> r) {
        Checks.notNull((String)"map", map);
        for (Map.Entry<?, ?> e : map.entrySet()) {
            if (t != Object.class && e.getKey() != null && !t.isInstance(e.getKey())) {
                throw new ClassCastException("Key " + e.getKey() + " is not an instance of " + t.getName() + " (value " + e.getValue() + ")");
            }
            if (r == Object.class || e.getValue() == null || r.isInstance(e.getValue())) continue;
            throw new ClassCastException("Value for key " + e.getKey() + " is not an instance of " + r.getName() + " (value " + e.getValue() + ")");
        }
        return map;
    }

    public static <T, R> Set<R> transform(Set<T> list, Function<T, R> xform) {
        LinkedHashSet result = new LinkedHashSet(list.size());
        list.stream().forEach(t -> {
            Object r = xform.apply(t);
            if (r != null) {
                result.add(r);
            }
        });
        return result;
    }

    public static <T, R> List<R> transform(List<T> list, Function<T, R> xform) {
        ArrayList result = new ArrayList(list.size());
        list.stream().forEach(t -> {
            Object r = xform.apply(t);
            if (r != null) {
                result.add(r);
            }
        });
        return result;
    }

    @SafeVarargs
    public static <T, R> List<R> transform(Function<T, R> xform, T ... args) {
        ArrayList<R> result = new ArrayList<R>();
        for (T obj : args) {
            R r = xform.apply(obj);
            if (r == null) continue;
            result.add(r);
        }
        return result;
    }

    public static <T> Map<T, Boolean> toMap(Set<T> set) {
        HashMap<T, Boolean> result = new HashMap<T, Boolean>();
        for (T t : set) {
            result.put(t, true);
        }
        return result;
    }

    public static <T, R> Map<T, R> toMap(Collection<R> coll, Function<R, T> func) {
        LinkedHashMap result = new LinkedHashMap();
        coll.stream().forEach(r -> {
            Object key = func.apply(r);
            result.put(key, r);
        });
        return result;
    }

    public static <T> Set<T> toSet(Map<T, Boolean> map) {
        HashSet<T> result = new HashSet<T>(map.size());
        for (Map.Entry<T, Boolean> e : map.entrySet()) {
            if (!Boolean.TRUE.equals(e.getValue())) continue;
            result.add(e.getKey());
        }
        return result;
    }

    public static <T> Set<T> setOf(T a) {
        return Collections.singleton(a);
    }

    public static <T> Set<T> setOf(T a, T b) {
        if (Objects.equals(a, b)) {
            return Collections.singleton(a);
        }
        return new ArraySet<Object>(false, a, b);
    }

    @SafeVarargs
    public static <T> Set<T> mutableSetOf(T ... args) {
        LinkedHashSet<T> result = new LinkedHashSet<T>();
        for (T t : args) {
            result.add(t);
        }
        return result;
    }

    public static <T> Set<T> setOf(T a, T b, T c) {
        if (a instanceof String && b instanceof String && c instanceof String) {
            return CollectionUtils.arraySetOf((Comparable[])new String[]{(String)a, (String)b, (String)c});
        }
        if (a instanceof CharSequence && b instanceof CharSequence && c instanceof CharSequence) {
            return CollectionUtils.charSequenceSetOf((CharSequence)a, (CharSequence)b, (CharSequence)c);
        }
        if (a instanceof Enum && b instanceof Enum && c instanceof Enum && a.getClass() == b.getClass() && a.getClass() == c.getClass()) {
            EnumSet<?> es = EnumSet.noneOf(a.getClass());
            es.add(a);
            es.add(b);
            es.add(c);
            return es;
        }
        boolean abEqual = Objects.equals(a, b);
        boolean acEqual = Objects.equals(a, c);
        if (abEqual && acEqual) {
            return Collections.singleton(a);
        }
        if (abEqual && !acEqual) {
            return new ArraySet<Object>(false, a, c);
        }
        if (acEqual && !abEqual) {
            return new ArraySet<Object>(false, a, b);
        }
        return new ArraySet<Object>(false, a, b, c);
    }

    @SafeVarargs
    public static <T> Set<T> identitySet(T ... objs) {
        return new ArrayBinarySet<Object>(false, true, new IdentityComparator(), objs);
    }

    @SafeVarargs
    public static <T> Set<T> arraySetOf(Comparator<T> comp, boolean useComparatorForMembershipTest, T ... objs) {
        if (objs.length == 0) {
            return Collections.emptySet();
        }
        return new ArrayBinarySet<T>(true, useComparatorForMembershipTest, comp, objs);
    }

    @SafeVarargs
    public static <T> Set<T> arraySetOf(Comparator<T> comp, T ... objs) {
        return CollectionUtils.arraySetOf(comp, false, objs);
    }

    @SafeVarargs
    public static <T extends Comparable<T>> Set<T> arraySetOf(T ... objs) {
        if (objs.length == 0) {
            return Collections.emptySet();
        }
        return new ArrayBinarySet(true, false, new ComparableComparator(), objs);
    }

    public static Set<CharSequence> charSequenceSetOf(CharSequence ... objs) {
        if (objs.length == 0) {
            return Collections.emptySet();
        }
        return new ArrayBinarySet<CharSequence>(true, false, Strings.charSequenceComparator((boolean)false), objs);
    }

    public static Set<String> caseInsensitiveStringSet(String ... str) {
        if (str.length == 0) {
            return Collections.emptySet();
        }
        return new ArrayBinarySet<String>(true, true, new StringComparator(), str);
    }

    public static Set<CharSequence> caseInsensitiveCharSequenceSet(CharSequence ... str) {
        if (str.length == 0) {
            return Collections.emptySet();
        }
        return new ArrayBinarySet<CharSequence>(true, true, Strings.charSequenceComparator((boolean)true), str);
    }

    @SafeVarargs
    public static <T> Set<T> setOf(T ... args) {
        if (args.length == 0) {
            return Collections.emptySet();
        }
        if (args.length == 1) {
            return Collections.singleton(args[0]);
        }
        if (args.length == 2) {
            return CollectionUtils.setOf(args[0], args[1]);
        }
        if (args.length == 3) {
            return CollectionUtils.setOf(args[0], args[1], args[2]);
        }
        if (Enum.class.isAssignableFrom(args.getClass().getComponentType())) {
            EnumSet<?> result = EnumSet.noneOf(args.getClass().getComponentType());
            for (T t : args) {
                result.add(t);
            }
            return result;
        }
        if (Comparable.class.isAssignableFrom(args.getClass().getComponentType()) && args.length < 30) {
            return new ArrayBinarySet(true, false, new ComparableComparator(), args);
        }
        if (args.length < 10) {
            return new ArraySet<T>(true, args);
        }
        LinkedHashSet<T> set = new LinkedHashSet<T>();
        for (T t : args) {
            set.add(t);
        }
        return set;
    }

    public static <T, R> Map<T, R> supplierMap(Supplier<R> valueSupplier) {
        return new SupplierMap((Supplier)Checks.notNull((String)"valueSupplier", valueSupplier));
    }

    public static <T, R> Map<T, R> weakSupplierMap(Supplier<R> valueSupplier) {
        return new SupplierMap((Supplier)Checks.notNull((String)"valueSupplier", valueSupplier), new WeakHashMap());
    }

    public static <T, R> Map<T, R> linkedSupplierMap(Supplier<R> valueSupplier) {
        return new SupplierMap((Supplier)Checks.notNull((String)"valueSupplier", valueSupplier), new LinkedHashMap());
    }

    public static <T, R> Map<R, Set<T>> invert(Map<? extends T, ? extends R> orig) {
        Checks.notNull((String)"orig", orig);
        Map<T, Set> result = CollectionUtils.supplierMap(HashSet::new);
        for (Map.Entry<T, R> e : orig.entrySet()) {
            result.get(e.getValue()).add(e.getKey());
        }
        return result;
    }

    public static <T, R> Map<T, R> concurrentSupplierMap(Supplier<R> valueSupplier) {
        return new SupplierMap(valueSupplier, new ConcurrentHashMap());
    }

    public static <T, R> Map<T, R> filterByKey(Map<T, R> map, Predicate<T> test) {
        HashMap result = map instanceof LinkedHashMap ? new LinkedHashMap() : new HashMap();
        for (Map.Entry<T, R> e : map.entrySet()) {
            if (!test.test(e.getKey())) continue;
            result.put(e.getKey(), e.getValue());
        }
        return result;
    }

    public static <T, R> Map<T, R> filterByValue(Map<T, R> map, Predicate<R> test) {
        HashMap result = map instanceof LinkedHashMap ? new LinkedHashMap() : new HashMap();
        for (Map.Entry<T, R> e : map.entrySet()) {
            if (!test.test(e.getValue())) continue;
            result.put(e.getKey(), e.getValue());
        }
        return result;
    }

    public static <T, R, X> Map<T, X> convertValues(Map<T, R> map, Function<R, X> conversion) {
        HashMap result = map instanceof LinkedHashMap ? new LinkedHashMap() : new HashMap();
        for (Map.Entry<T, R> e : map.entrySet()) {
            X val = conversion.apply(e.getValue());
            if (val == null) continue;
            result.put(e.getKey(), val);
        }
        return result;
    }

    public static <T> List<T> checkedListByCopy(List<?> l, Class<T> type, boolean filter) {
        ArrayList<T> result = new ArrayList<T>(l.size());
        for (Object o : l) {
            if (filter) {
                if (!type.isInstance(o)) continue;
                result.add(type.cast(o));
                continue;
            }
            result.add(type.cast(o));
        }
        return result;
    }

    public static List<?> toList(Object array) {
        return new UnknownTypeArrayList(array);
    }

    public static <T> List<T> iterableToList(Iterable<T> iterable) {
        ArrayList result = new ArrayList();
        for (Object t : (Iterable)Checks.notNull((String)"iterable", iterable)) {
            result.add(t);
        }
        return result;
    }

    public static <T> Set<T> iterableToSet(Iterable<T> iterable) {
        LinkedHashSet result = new LinkedHashSet();
        for (Object t : (Iterable)Checks.notNull((String)"iterable", iterable)) {
            result.add(t);
        }
        return result;
    }

    public static <T, R> Map<T, R> immutableArrayMap(Map<T, R> map, Class<T> keyType, Class<R> valType, LongResolvable func) {
        return new ImmutableArrayMap<T, R>(map, keyType, valType, func);
    }

    public static <T> List<T> reifiedListFromPossiblyNulList(List<?> list, Class<? super T> type) {
        if (list == null) {
            return Collections.emptyList();
        }
        return CollectionUtils.reifiedList(list, type);
    }

    public static <T> List<T> reifiedList(List<?> list, Class<? super T> type) {
        if (type == Object.class) {
            throw new IllegalArgumentException("Must be refining type - Object.class cannot be");
        }
        if (list == null) {
            return null;
        }
        return new ConvertList<T, Object>(type, Object.class, list, new ReifyingConverter(type));
    }

    public static <T, R> Map<R, T> reverse(Map<T, R> map) {
        HashMap result = map instanceof LinkedHashMap ? new LinkedHashMap() : new HashMap();
        for (Map.Entry<T, R> e : map.entrySet()) {
            T old = result.put(e.getValue(), e.getKey());
            if (old == null) continue;
            throw new IllegalArgumentException("Duplicate values " + e.getValue() + " but resulting map cannot contain duplicate keys - would lose data");
        }
        return result;
    }

    public static <T> T[] genericArray(Class<? super T> type, int length) {
        Checks.nonNegative((String)"length", (int)length);
        Checks.notNull((String)"type", type);
        return (Object[])Array.newInstance(type, length);
    }

    public static <T> T[] toArray(Collection<T> coll, Class<? super T> type) {
        return coll.toArray(CollectionUtils.genericArray(type, coll.size()));
    }

    public static <T, R> MapBuilder2.HashingMapBuilder<T, R> hashingMap(Function<Object, byte[]> byteConverter) {
        return CollectionUtils.map().toHashingMapBuilder("SHA-1", byteConverter);
    }

    public static <T, R> MapBuilder2.HashingMapBuilder<T, R> hashingMapWithAlgorithm(String alg, Function<Object, byte[]> byteConverter) {
        return CollectionUtils.map().toHashingMapBuilder("SHA-1");
    }

    public static <T, R> MapBuilder2.HashingMapBuilder<T, R> hashingMapWithAlgorithm(String alg) {
        return CollectionUtils.map().toHashingMapBuilder("SHA-1");
    }

    public static <T, R> MapBuilder2.HashingMapBuilder<T, R> hashingMap() {
        return CollectionUtils.map().toHashingMapBuilder("SHA-1");
    }

    public static <T, R> MapBuilder2.HashingMapBuilder.HashingValueBuilder<T, R> hashingMap(T key) {
        return CollectionUtils.map().toHashingMapBuilder("SHA-1").map((Object)key);
    }

    public static <T, R> MapBuilder2<T, R> map() {
        return new MapBuilder2Impl();
    }

    public static <T, R> MapBuilder2.ValueBuilder<T, R> map(T key) {
        return new MapBuilder2Impl().map(key);
    }

    public static <From, T, R> Map<From, R> convertedKeyMap(Class<From> from, Map<T, R> delegate, Converter<T, From> converter) {
        return new ConvertedMap(from, delegate, converter);
    }

    public static <R> Map<CharSequence, R> caseInsensitiveStringMap() {
        Converter converter = CharSequenceKey.converter();
        return new ConvertedMap(CharSequence.class, new HashMap(), converter);
    }

    public static <T extends CharSequence, R> Map<CharSequence, R> caseInsensitiveStringMap(Map<T, R> map) {
        Map<CharSequence, R> result = CollectionUtils.caseInsensitiveStringMap();
        for (Map.Entry<T, R> entry : map.entrySet()) {
            result.put((CharSequence)entry.getKey(), entry.getValue());
        }
        return result;
    }

    public static <T> IntMap<T> intMap() {
        return new ArrayIntMap();
    }

    public static <T> IntMap<T> intMap(Map<Integer, T> toCopy) {
        return new ArrayIntMap<T>(toCopy);
    }

    public static <T> IntMap<T> intMap(int initialCapacity) {
        return new ArrayIntMap(initialCapacity);
    }

    public static <T> IntMap<T> intMap(Supplier<T> emptyValues) {
        return CollectionUtils.intMap(96, false, emptyValues);
    }

    public static <T> IntMap<T> intMap(int initialCapacity, Supplier<T> emptyValues) {
        return CollectionUtils.intMap(initialCapacity, false, emptyValues);
    }

    public static <T> IntMap<T> intMap(int initialCapacity, boolean addSuppliedValues, Supplier<T> emptyValues) {
        return new ArrayIntMap<T>(initialCapacity, addSuppliedValues, emptyValues);
    }

    public static <T> List<T> oneItemList() {
        return new SingleItemList();
    }

    public static <T> List<T> oneItemList(T item) {
        return new SingleItemList<T>(item);
    }

    public static <T> List<T> reversed(List<T> list) {
        if (list instanceof ReversedList) {
            return ((ReversedList)list).delegate();
        }
        return new ReversedList<T>(list);
    }

    public static <T, R> List<R> convertedList(List<T> list, Converter<R, T> converter, Class<T> fromType, Class<R> toType) {
        return new ConvertList<R, T>(toType, fromType, list, converter);
    }

    public static <T, R> List<? extends R> converted(List<? extends T> list, Function<? super T, ? extends R> converter) {
        return new ConvertedReadOnlyList<T, R>(converter, list);
    }

    public static <T> List<T> generalize(List<? extends T> l) {
        return Collections.unmodifiableList(l);
    }

    public static <T, R> ListIterator<R> convertedIterator(Converter<R, T> c, Iterator<T> iter) {
        return CollectionUtils.convertedIterator(new WrapAsListIterator<T>(iter), c);
    }

    public static <T, R> ListIterator<R> convertedIterator(ListIterator<T> iter, Converter<R, T> c) {
        return new ConvertIterator<T, R>(iter, c);
    }

    public static <T> List<T> identityList(Collection<T> collection) {
        return new IdentityList<T>(collection);
    }

    public static <T> List<T> newIdentityList() {
        return new IdentityList();
    }

    @Deprecated
    public static <T, R> Converter<T, R> reverseConverter(Converter<R, T> c) {
        return new ReverseConverter<T, R>(c);
    }

    public static <T> Iterable<T> toIterable(Iterator<T> iterator) {
        return new IteratorIterable<T>(iterator);
    }

    public static <T> Iterable<T> toIterable(Supplier<Enumeration<T>> enumeration) {
        return () -> CollectionUtils.toIterator((Enumeration)enumeration.get());
    }

    public static <T> Iterator<T> combine(Collection<Iterator<T>> iterators) {
        return new MergeIterator<T>(iterators);
    }

    public static <T> ListIterator<T> combineListIterators(List<ListIterator<T>> iterators) {
        return iterators.isEmpty() ? Collections.emptyListIterator() : new MergeListIterator<T>(iterators);
    }

    public static <T> ListIterator<T> combineListIterators(ListIterator<T> a, ListIterator<T> b) {
        return new MergeListIterator(Arrays.asList(a, b));
    }

    public static <T> Iterator<T> combine(Iterator<T> a, Iterator<T> b) {
        Checks.notNull((String)"a", a);
        Checks.notNull((String)"b", b);
        return new MergeIterator(Arrays.asList(a, b));
    }

    public static <T> List<T> combinedList(List<T> a, List<T> b) {
        return CollectionUtils.combinedList(Arrays.asList(a, b));
    }

    public static <T> List<T> combinedList(List<List<T>> lists) {
        return ((List)Checks.notNull((String)"lists", lists)).isEmpty() ? Collections.emptyList() : new MultiList<T>(lists);
    }

    public static <T> List<T> combinedList(Collection<? extends Collection<T>> lists) {
        return ((Collection)Checks.notNull((String)"lists", lists)).isEmpty() ? Collections.emptyList() : new MultiList(lists);
    }

    public static <T> Iterator<T> singletonIterator(T obj) {
        return new SingletonIterator<T>(obj);
    }

    public static <T> Iterator<T> toIterator(T[] array) {
        Checks.notNull((String)"array", array);
        return new ArrayIterator<T>(array);
    }

    public static <T> Iterable<T> toIterable(T[] array) {
        Checks.notNull((String)"array", array);
        return CollectionUtils.toIterable(CollectionUtils.toIterator(array));
    }

    public static <T> Enumeration<T> toEnumeration(Iterable<T> iter) {
        Checks.notNull((String)"iter", iter);
        return CollectionUtils.toEnumeration(iter.iterator());
    }

    public static <T> Enumeration<T> toEnumeration(Iterator<T> iter) {
        Checks.notNull((String)"iter", iter);
        return new EnumerationAdapter<T>(iter);
    }

    public static <T> Iterator<T> toReverseIterator(T[] array) {
        Checks.notNull((String)"array", array);
        return new ReverseArrayIterator<T>(array);
    }

    public static <T> AtomicIterator<T> synchronizedIterator(Iterator<T> iter) {
        return new AtomicIteratorImpl<T>(iter);
    }

    public static <T> Set<T> intersection(Collection<T> a, Collection<T> b) {
        if (a == b) {
            return a instanceof Set ? (Set<Object>)a : new HashSet<T>(a);
        }
        if (a instanceof IntSet && b instanceof IntSet) {
            return ((IntSet)a).intersection((IntSet)b);
        }
        HashSet<T> result = new HashSet<T>(a);
        result.retainAll(b);
        return result;
    }

    public static <T> Set<T> disjunction(Collection<T> a, Collection<T> b) {
        if (a == b) {
            return Collections.emptySet();
        }
        HashSet<T> bs = new HashSet<T>(b);
        bs.removeAll(a);
        return bs;
    }

    public static <T> boolean intersects(Collection<T> a, Collection<T> b) {
        return !CollectionUtils.intersection(a, b).isEmpty();
    }

    public static <T> Iterable<T> toIterable(Enumeration<T> enumeration) {
        return new EnumIterable<T>(enumeration);
    }

    public static <T> Iterator<T> toIterator(Enumeration<T> enumeration) {
        return new EnumIterator<T>(enumeration);
    }

    public static Iterator<Integer> toIterator(int[] vals) {
        return new IntArrayIterator(vals);
    }

    public static Iterator<Long> toIterator(long[] vals) {
        return new LongArrayIterator(vals);
    }

    public static Interator toInterator(int[] vals) {
        return new ArrayInterator(vals);
    }

    public static Longerator toLongerator(long[] vals) {
        return new ArrayLongerator(vals);
    }

    private static final class ArrayLongerator
    implements Longerator {
        private final long[] vals;
        int ix = 0;

        public ArrayLongerator(long[] vals) {
            this.vals = vals;
        }

        @Override
        public long next() {
            return this.vals[this.ix++];
        }

        @Override
        public boolean hasNext() {
            return this.ix < this.vals.length;
        }
    }

    private static final class ArrayInterator
    implements Interator {
        private final int[] vals;
        int ix = 0;

        public ArrayInterator(int[] vals) {
            this.vals = vals;
        }

        @Override
        public boolean hasNext() {
            return this.ix < this.vals.length;
        }

        @Override
        public int next() {
            return this.vals[this.ix++];
        }
    }

    private static final class LongArrayIterator
    implements Iterator<Long> {
        private final long[] vals;
        int ix = 0;

        public LongArrayIterator(long[] vals) {
            this.vals = vals;
        }

        @Override
        public boolean hasNext() {
            return this.ix < this.vals.length;
        }

        @Override
        public Long next() {
            return this.vals[this.ix++];
        }

        @Override
        public void forEachRemaining(Consumer<? super Long> action) {
            for (int i = 0; i < this.vals.length; ++i) {
                action.accept((Long)this.vals[i]);
            }
        }
    }

    private static final class IntArrayIterator
    implements Iterator<Integer> {
        private final int[] vals;
        int ix = 0;

        public IntArrayIterator(int[] vals) {
            this.vals = vals;
        }

        @Override
        public boolean hasNext() {
            return this.ix < this.vals.length;
        }

        @Override
        public Integer next() {
            return this.vals[this.ix++];
        }

        @Override
        public void forEachRemaining(Consumer<? super Integer> action) {
            for (int i = 0; i < this.vals.length; ++i) {
                action.accept((Integer)this.vals[i]);
            }
        }
    }

    static class SingletonIterator<T>
    implements Iterator<T> {
        private final T object;
        private boolean done;

        public SingletonIterator(T object) {
            this.object = object;
        }

        @Override
        public boolean hasNext() {
            return !this.done;
        }

        @Override
        public T next() {
            if (this.done) {
                throw new NoSuchElementException();
            }
            this.done = true;
            return this.object;
        }

        @Override
        public void forEachRemaining(Consumer<? super T> action) {
            if (!this.done) {
                this.done = true;
                action.accept(this.object);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static final class EnumIterator<T>
    implements Iterator<T>,
    Iterable<T> {
        private final Enumeration<T> enumeration;

        public EnumIterator(Enumeration<T> enumeration) {
            this.enumeration = enumeration;
        }

        @Override
        public boolean hasNext() {
            return this.enumeration.hasMoreElements();
        }

        @Override
        public T next() {
            return this.enumeration.nextElement();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported");
        }

        @Override
        public Iterator<T> iterator() {
            return new EnumIterator<T>(this.enumeration);
        }
    }

    private static final class EnumIterable<T>
    implements Iterable<T> {
        private final Enumeration<T> en;

        public EnumIterable(Enumeration<T> en) {
            this.en = en;
        }

        @Override
        public Iterator<T> iterator() {
            return CollectionUtils.toIterator(this.en);
        }
    }

    private static class IteratorIterable<T>
    implements Iterable<T> {
        private final Iterator<T> iter;

        public IteratorIterable(Iterator<T> iter) {
            this.iter = iter;
        }

        @Override
        public Iterator<T> iterator() {
            return this.iter;
        }

        public String toString() {
            return "Iterable wrapper for " + this.iter;
        }
    }

    private static final class MergeIterator<T>
    implements Iterator<T> {
        private final LinkedList<Iterator<T>> iterators = new LinkedList();

        MergeIterator(Collection<Iterator<T>> iterators) {
            this.iterators.addAll(iterators);
        }

        private Iterator<T> iter() {
            if (this.iterators.isEmpty()) {
                return null;
            }
            Iterator<T> result = this.iterators.get(0);
            if (!result.hasNext()) {
                this.iterators.remove(0);
                return this.iter();
            }
            return result;
        }

        @Override
        public boolean hasNext() {
            Iterator<T> curr = this.iter();
            return curr != null && curr.hasNext();
        }

        @Override
        public T next() {
            Iterator<T> iter = this.iter();
            if (iter == null) {
                throw new NoSuchElementException();
            }
            return iter.next();
        }

        @Override
        public void remove() {
            Iterator<T> iter = this.iter();
            if (iter == null) {
                throw new NoSuchElementException();
            }
            iter.remove();
        }
    }

    private static final class ReverseArrayIterator<T>
    implements Iterator<T> {
        private final T[] items;
        private int ix;

        public ReverseArrayIterator(T[] items) {
            this.items = items;
            this.ix = items.length - 1;
        }

        @Override
        public boolean hasNext() {
            return this.ix >= 0;
        }

        @Override
        public T next() {
            return this.items[this.ix--];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Cannot delete from an array");
        }
    }

    private static final class ArrayIterator<T>
    implements Iterator<T> {
        private final T[] items;
        private int ix = 0;

        public ArrayIterator(T[] items) {
            this.items = items;
        }

        @Override
        public boolean hasNext() {
            return this.ix < this.items.length;
        }

        @Override
        public T next() {
            return this.items[this.ix++];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Cannot delete from an array");
        }
    }

    private static final class AtomicIteratorImpl<T>
    implements AtomicIterator<T> {
        private final Iterator<T> iter;

        AtomicIteratorImpl(Iterator<T> iter) {
            this.iter = iter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasNext() {
            AtomicIteratorImpl atomicIteratorImpl = this;
            synchronized (atomicIteratorImpl) {
                return this.iter.hasNext();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T next() {
            AtomicIteratorImpl atomicIteratorImpl = this;
            synchronized (atomicIteratorImpl) {
                T result = this.iter.next();
                if (result == null) {
                    throw new IllegalStateException("Null elements not permitted");
                }
                return result;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T getIfHasNext() {
            AtomicIteratorImpl atomicIteratorImpl = this;
            synchronized (atomicIteratorImpl) {
                if (this.iter.hasNext()) {
                    return this.next();
                }
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove() {
            AtomicIteratorImpl atomicIteratorImpl = this;
            synchronized (atomicIteratorImpl) {
                this.iter.remove();
            }
        }
    }

    public static interface AtomicIterator<T>
    extends Iterator<T> {
        public T getIfHasNext();
    }

    static final class ReifyingConverter<T, R extends T>
    implements Converter<R, Object> {
        private final Class<R> type;

        public ReifyingConverter(Class<? super T> type) {
            this.type = type;
        }

        @Override
        public R convert(Object r) {
            return this.type.cast(r);
        }

        @Override
        public Object unconvert(R t) {
            return t;
        }
    }

    static final class ComparableComparator<T extends Comparable<T>>
    implements Comparator<T> {
        ComparableComparator() {
        }

        @Override
        public int compare(T o1, T o2) {
            return o1.compareTo(o2);
        }
    }

    static final class StringComparator
    implements Comparator<String> {
        StringComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            return o1.compareToIgnoreCase(o2);
        }
    }

    static final class IdentityComparator
    implements Comparator<Object> {
        IdentityComparator() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            int a = System.identityHashCode(o1);
            int b = System.identityHashCode(o2);
            return Integer.compare(a, b);
        }
    }
}

