/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.util.collections;

import com.mastfrog.abstractions.list.IndexedResolvable;
import com.mastfrog.util.collections.CollectionUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

final class ComparatorListIndexedImpl<T>
implements IndexedResolvable<T> {
    private final Object[] sorted;
    private final int[] indices;
    private final List<T> origOrder;

    ComparatorListIndexedImpl(Comparator<T> compar, List<T> items) {
        this.origOrder = items;
        this.sorted = items.toArray();
        Arrays.sort(this.sorted, compar);
        this.indices = new int[items.size()];
        ArrayList<T> order = new ArrayList<T>(items);
        CollectionUtils.checkDuplicates(order);
        for (int i = 0; i < items.size(); ++i) {
            Object s = this.sorted[i];
            this.indices[i] = order.indexOf(s);
        }
    }

    static <T extends Comparable<T>> IndexedResolvable<T> create(List<T> items) {
        return new ComparatorListIndexedImpl(new CollectionUtils.ComparableComparator(), items);
    }

    public int size() {
        return this.sorted.length;
    }

    public int indexOf(Object o) {
        int ix = Arrays.binarySearch(this.sorted, o);
        return ix < 0 ? -1 : this.indices[ix];
    }

    public T forIndex(int index) {
        return this.origOrder.get(index);
    }
}

