/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.util.collections;

import com.mastfrog.util.collections.Converter;
import java.util.ListIterator;

final class ConvertIterator<T, R>
implements ListIterator<R> {
    private final ListIterator<T> orig;
    private final Converter<R, T> converter;

    public ConvertIterator(ListIterator<T> orig, Converter<R, T> converter) {
        this.orig = orig;
        this.converter = converter;
    }

    @Override
    public boolean hasNext() {
        return this.orig.hasNext();
    }

    @Override
    public R next() {
        return this.converter.convert(this.orig.next());
    }

    @Override
    public boolean hasPrevious() {
        return this.orig.hasPrevious();
    }

    @Override
    public R previous() {
        return this.converter.convert(this.orig.previous());
    }

    @Override
    public int nextIndex() {
        return this.orig.nextIndex();
    }

    @Override
    public int previousIndex() {
        return this.orig.previousIndex();
    }

    @Override
    public void remove() {
        this.orig.remove();
    }

    @Override
    public void set(R e) {
        this.orig.set(this.converter.unconvert(e));
    }

    @Override
    public void add(R e) {
        this.orig.add(this.converter.unconvert(e));
    }

    public String toString() {
        return "ConvertIterator with " + this.converter + " over " + this.orig;
    }
}

