/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.util.collections;

import com.mastfrog.util.collections.Converter;
import com.mastfrog.util.collections.ReverseConverter;
import com.mastfrog.util.preconditions.Checks;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;

final class ConvertList<T, R>
implements List<T> {
    private final Class<T> type;
    private final Class<R> origType;
    private final List<R> orig;
    private final Converter<T, R> converter;

    ConvertList(Class<T> toType, Class<R> fromType, List<R> orig, Converter<T, R> converter) {
        Checks.notNull((String)"orig", orig);
        Checks.notNull((String)"converter", converter);
        Checks.notNull((String)"toType", toType);
        Checks.notNull((String)"fromType", fromType);
        this.type = toType;
        this.origType = fromType;
        this.orig = orig;
        this.converter = converter;
    }

    @Override
    public int size() {
        return this.orig.size();
    }

    @Override
    public boolean isEmpty() {
        return this.orig.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        if (this.type.isInstance(o)) {
            return this.orig.contains(this.converter.unconvert(this.type.cast(o)));
        }
        return false;
    }

    @Override
    public Iterator<T> iterator() {
        return this.listIterator();
    }

    @Override
    public Object[] toArray() {
        int max = this.size();
        Object[] result = (Object[])Array.newInstance(this.type, max);
        for (int i = 0; i < max; ++i) {
            result[i] = this.get(i);
        }
        return result;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        int max = this.size();
        if (a.length != max) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), max);
        }
        for (int i = 0; i < max; ++i) {
            a[i] = this.get(i);
        }
        return a;
    }

    @Override
    public boolean add(T e) {
        return this.orig.add(this.converter.unconvert(e));
    }

    @Override
    public boolean remove(Object o) {
        if (this.type.isInstance(o)) {
            R r = this.converter.unconvert(this.type.cast(o));
            return this.orig.remove(r);
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        for (T t : c) {
            this.orig.add(this.converter.unconvert(t));
        }
        return true;
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        return this.orig.addAll(new ConvertList<R, T>(this.origType, this.type, this.toList(c), new ReverseConverter<R, T>(this.converter)));
    }

    private List<T> toList(Collection<? extends T> c) {
        if (c instanceof List) {
            return (List)c;
        }
        return new ArrayList<T>(c);
    }

    private List<R> convertList(Collection<?> c) {
        ArrayList<R> result = new ArrayList<R>();
        for (Object o : c) {
            if (!this.type.isInstance(o)) continue;
            result.add(this.converter.unconvert(this.type.cast(o)));
        }
        return result;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.orig.removeAll(this.convertList(c));
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.orig.retainAll(this.convertList(c));
    }

    @Override
    public void clear() {
        this.orig.clear();
    }

    @Override
    public T get(int index) {
        return this.converter.convert(this.orig.get(index));
    }

    @Override
    public T set(int index, T element) {
        return this.converter.convert(this.orig.set(index, this.converter.unconvert(element)));
    }

    @Override
    public void add(int index, T element) {
        this.orig.add(index, this.converter.unconvert(element));
    }

    @Override
    public T remove(int index) {
        return this.converter.convert(this.orig.remove(index));
    }

    @Override
    public int indexOf(Object o) {
        return this.type.isInstance(o) ? this.orig.indexOf(this.converter.unconvert(this.type.cast(o))) : -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.type.isInstance(o) ? this.orig.lastIndexOf(this.converter.unconvert(this.type.cast(o))) : -1;
    }

    @Override
    public ListIterator<T> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof List)) {
            return false;
        }
        if (o instanceof ConvertList) {
            ConvertList c = (ConvertList)o;
            if (Objects.equals(c.converter, this.converter)) {
                return Objects.equals(c.orig, this.orig);
            }
        }
        ListIterator<T> e1 = this.listIterator();
        ListIterator e2 = ((List)o).listIterator();
        while (e1.hasNext() && e2.hasNext()) {
            Object o2;
            T o1 = e1.next();
            if (Objects.equals(o1, o2 = e2.next())) continue;
            return false;
        }
        return !e1.hasNext() && !e2.hasNext();
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        for (T e : this) {
            hashCode = 31 * hashCode + (e == null ? 0 : e.hashCode());
        }
        return hashCode;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (T obj : this) {
            if (sb.length() != 0) {
                sb.append(',');
            }
            sb.append(obj);
        }
        return sb.toString();
    }

    @Override
    public ListIterator<T> listIterator(final int index) {
        return new ListIterator<T>(){
            private final ListIterator<R> delegate;
            {
                this.delegate = ConvertList.this.orig.listIterator(index);
            }

            @Override
            public boolean hasNext() {
                return this.delegate.hasNext();
            }

            @Override
            public T next() {
                return ConvertList.this.converter.convert(this.delegate.next());
            }

            @Override
            public boolean hasPrevious() {
                return this.delegate.hasPrevious();
            }

            @Override
            public T previous() {
                return ConvertList.this.converter.convert(this.delegate.previous());
            }

            @Override
            public int nextIndex() {
                return this.delegate.nextIndex();
            }

            @Override
            public int previousIndex() {
                return this.delegate.previousIndex();
            }

            @Override
            public void remove() {
                this.delegate.remove();
            }

            @Override
            public void set(T e) {
                this.delegate.set(ConvertList.this.converter.unconvert(e));
            }

            @Override
            public void add(T e) {
                this.delegate.add(ConvertList.this.converter.unconvert(e));
            }
        };
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        return new ConvertList<T, R>(this.type, this.origType, this.orig.subList(fromIndex, toIndex), this.converter);
    }
}

