/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.util.collections;

import com.mastfrog.util.collections.Converter;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

class ConvertedMap<From, T, R, F2 extends From>
implements Map<From, R> {
    private final Class<F2> from;
    private final Map<T, R> delegate;
    private final Converter<T, F2> converter;

    public ConvertedMap(Class<F2> from, Map<T, R> delegate, Converter<T, F2> converter) {
        this.from = from;
        this.delegate = delegate;
        this.converter = converter;
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    protected boolean isKey(Object key) {
        return this.from.isInstance(key);
    }

    @Override
    public boolean containsKey(Object key) {
        if (this.isKey(key)) {
            F2 f = this.from.cast(key);
            T realKey = this.converter.convert(f);
            return this.delegate.containsKey(realKey);
        }
        return false;
    }

    private T toKey(Object key) {
        if (key == null) {
            return null;
        }
        if (this.isKey(key)) {
            F2 f = this.from.cast(key);
            return this.converter.convert(f);
        }
        return null;
    }

    @Override
    public boolean containsValue(Object value) {
        return this.delegate.containsValue(value);
    }

    @Override
    public R get(Object key) {
        if (key == null) {
            return this.delegate.get(null);
        }
        T realKey = this.toKey(key);
        return realKey == null ? null : (R)this.delegate.get(realKey);
    }

    @Override
    public R put(From key, R value) {
        Object realKey = key == null ? null : (Object)this.toKey(key);
        return this.delegate.put(realKey, value);
    }

    @Override
    public R remove(Object key) {
        T realKey = this.toKey(key);
        return this.delegate.remove(realKey);
    }

    @Override
    public void putAll(Map<? extends From, ? extends R> m) {
        for (Map.Entry<From, R> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    public Set<From> keySet() {
        HashSet<F2> result = new HashSet<F2>(this.size());
        for (T key : this.delegate.keySet()) {
            result.add(this.converter.unconvert(key));
        }
        return result;
    }

    @Override
    public Collection<R> values() {
        return this.delegate.values();
    }

    @Override
    public Set<Map.Entry<From, R>> entrySet() {
        HashSet<Map.Entry<From, R>> entries = new HashSet<Map.Entry<From, R>>();
        for (Map.Entry<T, R> e : this.delegate.entrySet()) {
            entries.add(new En(e));
        }
        return entries;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o instanceof Map) {
            ConvertedMap other = this;
            if (other.size() != this.size()) {
                return false;
            }
            for (Map.Entry e : other.entrySet()) {
                if (Objects.equals(e.getValue(), this.get(e.getKey()))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int h = 0;
        Iterator<Map.Entry<From, R>> i = this.entrySet().iterator();
        while (i.hasNext()) {
            h += i.next().hashCode();
        }
        return h;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getName()).append(System.identityHashCode(this)).append("from=").append(this.from.getName()).append(", converter=").append(this.converter).append(",entries={");
        for (Map.Entry<From, R> e : this.entrySet()) {
            sb.append(e.getKey()).append('=').append(e.getValue()).append(' ');
        }
        return sb.append('}').toString();
    }

    final class En
    implements Map.Entry<From, R> {
        private final Map.Entry<T, R> real;

        public En(Map.Entry<T, R> real) {
            this.real = real;
        }

        @Override
        public From getKey() {
            return ConvertedMap.this.converter.unconvert(this.real.getKey());
        }

        @Override
        public R getValue() {
            return this.real.getValue();
        }

        @Override
        public R setValue(R value) {
            return this.real.setValue(value);
        }

        @Override
        public int hashCode() {
            Object key = this.getKey();
            Object value = this.getValue();
            return (key == null ? 0 : key.hashCode()) ^ (value == null ? 0 : value.hashCode());
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            En other = (En)obj;
            return Objects.equals(this.real, other.real);
        }
    }
}

