/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.util.collections;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.function.Function;

final class ConvertedReadOnlyList<T, R>
implements List<R> {
    private final Function<? super T, ? extends R> converter;
    private final List<? extends T> list;

    public ConvertedReadOnlyList(Function<? super T, ? extends R> converter, List<? extends T> list) {
        this.converter = converter;
        this.list = list;
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        for (int i = 0; i < this.size(); ++i) {
            if (!Objects.equals(o, this.get(i))) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<R> iterator() {
        return new CVIT(this.list.iterator());
    }

    @Override
    public Object[] toArray() {
        Object[] result = new Object[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            result[i] = this.get(i);
        }
        return result;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        if (a.length < this.size()) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), this.size());
        }
        for (int i = 0; i < this.size(); ++i) {
            a[i] = this.get(i);
        }
        return a;
    }

    @Override
    public boolean add(R e) {
        throw new UnsupportedOperationException("Read only");
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException("Read only");
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends R> c) {
        throw new UnsupportedOperationException("Read only");
    }

    @Override
    public boolean addAll(int index, Collection<? extends R> c) {
        throw new UnsupportedOperationException("Read only");
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException("Read only");
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException("Read only");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Read only");
    }

    @Override
    public R get(int index) {
        return this.converter.apply(this.list.get(index));
    }

    @Override
    public R set(int index, R element) {
        throw new UnsupportedOperationException("Read only");
    }

    @Override
    public void add(int index, R element) {
        throw new UnsupportedOperationException("Read only");
    }

    @Override
    public R remove(int index) {
        throw new UnsupportedOperationException("Read only");
    }

    @Override
    public int indexOf(Object o) {
        for (int i = 0; i < this.size(); ++i) {
            if (!Objects.equals(this.get(i), o)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        for (int i = this.size() - 1; i >= 0; --i) {
            if (!Objects.equals(o, this.get(i))) continue;
            return i;
        }
        return -1;
    }

    @Override
    public ListIterator<R> listIterator() {
        return new CVLI(this.list.listIterator());
    }

    @Override
    public ListIterator<R> listIterator(int index) {
        return new CVLI(this.list.listIterator(index));
    }

    @Override
    public List<R> subList(int fromIndex, int toIndex) {
        return new ConvertedReadOnlyList<T, R>(this.converter, this.list.subList(fromIndex, toIndex));
    }

    public String toString() {
        Iterator<R> it = this.iterator();
        if (!it.hasNext()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        while (true) {
            R value;
            sb.append((Object)((value = it.next()) == this ? "(this Collection)" : value));
            if (!it.hasNext()) {
                return sb.append(']').toString();
            }
            sb.append(',').append(' ');
        }
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof List)) {
            return false;
        }
        ListIterator<R> e1 = this.listIterator();
        ListIterator e2 = ((List)o).listIterator();
        while (e1.hasNext() && e2.hasNext()) {
            R o1 = e1.next();
            Object o2 = e2.next();
            if (o1 != null ? o1.equals(o2) : o2 == null) continue;
            return false;
        }
        return !e1.hasNext() && !e2.hasNext();
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        for (R e : this) {
            hashCode = 31 * hashCode + (e == null ? 0 : e.hashCode());
        }
        return hashCode;
    }

    class CVLI
    implements ListIterator<R> {
        private final ListIterator<? extends T> it;

        public CVLI(ListIterator<? extends T> it) {
            this.it = it;
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public R next() {
            return ConvertedReadOnlyList.this.converter.apply(this.it.next());
        }

        @Override
        public boolean hasPrevious() {
            return this.it.hasPrevious();
        }

        @Override
        public R previous() {
            return ConvertedReadOnlyList.this.converter.apply(this.it.previous());
        }

        @Override
        public int nextIndex() {
            return this.it.nextIndex();
        }

        @Override
        public int previousIndex() {
            return this.it.previousIndex();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Read only");
        }

        @Override
        public void set(R e) {
            throw new UnsupportedOperationException("Read only");
        }

        @Override
        public void add(R e) {
            throw new UnsupportedOperationException("Read only");
        }
    }

    final class CVIT
    implements Iterator<R> {
        private final Iterator<? extends T> it;

        public CVIT(Iterator<? extends T> it) {
            this.it = it;
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public R next() {
            return ConvertedReadOnlyList.this.converter.apply(this.it.next());
        }
    }
}

