/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.util.collections;

import com.mastfrog.util.collections.DoubleMapConsumer;
import com.mastfrog.util.collections.DoubleMapImpl;
import com.mastfrog.util.collections.DoubleSet;
import java.util.List;

public interface DoubleMap<T> {
    public static <T> DoubleMap<T> create() {
        return DoubleMap.create(128);
    }

    public static <T> DoubleMap<T> create(int initialCapacity) {
        return new DoubleMapImpl(initialCapacity);
    }

    default public boolean isEmpty() {
        return this.size() == 0;
    }

    public void put(double var1, T var3);

    public T get(double var1);

    public T getOrDefault(double var1, T var3);

    public int size();

    public boolean containsKey(double var1);

    public DoubleSet keySet();

    public double key(int var1);

    public T valueAt(int var1);

    public List<T> values();

    public int indexOf(double var1);

    public boolean nearestValueExclusive(double var1, double var3, DoubleMapConsumer<? super T> var5);

    public boolean nearestValueExclusive(double var1, DoubleMapConsumer<? super T> var3);

    public boolean nearestValueTo(double var1, DoubleMapConsumer<? super T> var3);

    public boolean nearestValueTo(double var1, double var3, DoubleMapConsumer<? super T> var5);

    public boolean greatest(DoubleMapConsumer<? super T> var1);

    public boolean least(DoubleMapConsumer<? super T> var1);

    public void forEach(DoubleMapConsumer<? super T> var1);

    public int removeRange(double var1, double var3);

    public boolean remove(double var1);

    public void removeAll(double ... var1);

    public void removeAll(DoubleSet var1);
}

